% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCov.R
\name{plotCov}
\alias{plotCov}
\title{plotCov}
\usage{
plotCov(
  peak,
  weightCol = NULL,
  facet_level = NULL,
  highlight = NULL,
  highlight_color = "#c6c3c3",
  highlight_alpha = 0.2,
  xlab = "Chromosome Size (bp)",
  ylab = "",
  interactive = FALSE,
  width_svg = 10,
  height_svg = 6,
  title = "ChIP Peaks over Chromosomes",
  x_text_size = 10,
  y_text_size = 10,
  facet_label_text_size = 10,
  chrs = NULL,
  xlim = NULL,
  facet_var = NULL,
  facet_scales = "free",
  lower = 1,
  fill_color = "black",
  add_cluster_tree = FALSE,
  cluster_dist_method = "euclidean",
  cluster_hclust_methond = "complete",
  legend_position = NULL,
  add_coaccess = FALSE,
  curvature = 0.3,
  coaccess_top_n = NULL,
  coaccess_cor_threshold = NULL,
  design = NULL,
  coaccess_legend_pos = c(0.9, 0.5),
  coaccess_legend_text_size = 10,
  coaccess_legend_title_size = 12
)
}
\arguments{
\item{peak}{peak file or GRanges object.}

\item{weightCol}{weight column of peak.}

\item{facet_level}{facet_level.}

\item{highlight}{a region or a list of region to highlight.}

\item{highlight_color}{colors of highlight rect. Default "#c6c3c3"}

\item{highlight_alpha}{alpha of highlight rect.}

\item{xlab}{xlab.}

\item{ylab}{ylab.}

\item{interactive}{produce interactive fig or not.}

\item{width_svg}{width_svg}

\item{height_svg}{height_svg}

\item{title}{title.}

\item{x_text_size}{the size of x text.}

\item{y_text_size}{the size of y text.}

\item{facet_label_text_size}{the size of facet label text.}

\item{chrs}{selected chromosomes to plot, all chromosomes by default.}

\item{xlim}{ranges to plot, default is whole chromosome.}

\item{facet_var}{how to facet. one of c("chr~.", ".~ chr", ".~.id", ".id~.", ".id~chr", "chr~.id")}

\item{facet_scales}{how to scale facet data. Default: "free".}

\item{lower}{lower cutoff of coverage signal.}

\item{fill_color}{specify the color/palette for the plot. Order matters.}

\item{add_cluster_tree}{add cluster tree for samples or not.}

\item{cluster_dist_method}{method for calculate cluster tree. Details see [stats::dist()]}

\item{cluster_hclust_methond}{method for hclust. Details see [stats::hclust()]}

\item{legend_position}{legend_position}

\item{add_coaccess}{add co-accessibility or not}

\item{curvature}{curvature.}

\item{coaccess_top_n}{top n co-accessibility to show, default: 3.}

\item{coaccess_cor_threshold}{co-access peak cor threshold.}

\item{design}{the design layout of figure.}

\item{coaccess_legend_pos}{the legend position of co-accessibiliy plot legend.}

\item{coaccess_legend_text_size}{the legend position of co-accessibiliy plot legend text size.}

\item{coaccess_legend_title_size}{the legend position of co-accessibiliy plot legend title size.}
}
\value{
ggplot2 object
}
\description{
plotCov
}
\details{
Plot peak coverage
}
\examples{
peakfile <- system.file("extdata", "sample_peaks.txt", package="epiSeeker")
peak <- readPeakFile(peakfile)
plotCov(peak)
}
\author{
G Yu
}
