% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiSeeker-package.R
\docType{data}
\name{pwm_obj}
\alias{pwm_obj}
\title{motif reference for Homo sapiens}
\format{
A \code{PFMatrixList} object containing PWMs for multiple human
transcription factors from the JASPAR 2024 CORE collection.
}
\value{
pwm_obj
}
\description{
A collection of transcription factor position weight matrices (PWMs)
retrieved from the JASPAR 2024 database.  
This dataset is used to demonstrate motif enrichment, motif scanning,
and peak–motif association analyses in \pkg{epiSeeker}.
See data-raw/example_data.R
}
\section{Provenance}{

The PWM set was obtained using the JASPAR 2024 SQLite database bundled in
the \pkg{JASPAR2024} package.  
Matrices were retrieved using \pkg{TFBSTools} with the following parameters:
\itemize{
  \item \code{collection = "CORE"}
  \item \code{all_versions = FALSE}
  \item \code{species = "Homo sapiens"}
  \item \code{tax_group = "vertebrates"}
}
}

\section{Data structure}{

A \code{TFBSTools::PWMatrixList} (or \code{PFMatrixList}) object containing
one PWM per transcription factor.  
Each matrix stores nucleotide position weights across the TF binding motif,
with rows representing \code{A, C, G, T} and columns representing motif positions.
}

