% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_quantile.R
\name{epi_quantile}
\alias{epi_quantile}
\title{Identifies epimutations using quantile distribution}
\usage{
epi_quantile(
  case,
  fd,
  bctr_pmin,
  bctr_pmax,
  controls,
  betas,
  window_sz = 1000,
  N = 3,
  offset_abs = 0.15
)
}
\arguments{
\item{case}{beta values for a
single case (data.frame). The samples as
single column and CpGs in rows (named).}

\item{fd}{feature description as
data.frame having at least chromosome and
position as columns and and CpGs in rows (named).}

\item{bctr_pmin}{Beta value observed
at 0.01 quantile in controls. A beta
values has to be lower or equal
to this value to be considered an
epimutation.}

\item{bctr_pmax}{Beta value observed
at 0.99 quantile in controls. A beta
values has to be higher or equal
to this value to be considered an
epimutation.}

\item{controls}{control samples names.}

\item{betas}{a matrix containing the
beta values for all samples.}

\item{window_sz}{Maximum distance
between a pair of CpGs to defined an
region of CpGs as epimutation (default: 1000).}

\item{N}{Minimum number of CpGs,
separated in a maximum of window_sz bass,
to defined an epimutation (default: 3).}

\item{offset_abs}{Extra enforcement
defining an epimutation based on
beta values at 0.005 and 0.995 quantiles (default: 0.15).}
}
\value{
The function returns a data
frame with the regions candidates to be
epimutations.
}
\description{
Identifies CpGs with
outlier methylation values
using a sliding window
approach to compare individual
methylation profiles of a single
case sample against all other
samples from reference panel (controls)
}
