% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{plotDiffNetwork}
\alias{plotDiffNetwork}
\title{Plot graph according to grouping factor}
\usage{
plotDiffNetwork(
  regulon,
  cutoff = 0.01,
  tf = NULL,
  weight = "weight",
  clusters,
  layout = "stress"
)
}
\arguments{
\item{regulon}{an object returned by the getRegulon or addWeights function}

\item{cutoff}{a numeric used to select values of the variables passed in \code{clusters}
parameter. Values greater than \code{cutoff} are retained and used as
graph edge weights.}

\item{tf}{a character vector storing the names of transcription factors to be
included in the graph}

\item{weight}{a string indicating the name of the column in the regulon to be used as
the weight of the edges}

\item{clusters}{a character vector indicating the clusters to be plotted}

\item{layout}{a layout specification. Any values that are valid for
\link[ggraph]{ggraph} or \link[ggraph]{create_layout} will work.}
}
\value{
a ggraph object
}
\description{
Plot graph with separate weights for different levels of the grouping factor
}
\examples{
#' # create an artificial getRegulon output
set.seed(1234)
tf_set <- apply(expand.grid(LETTERS[1:10], LETTERS[1:10]),1,  paste, collapse = '')
regulon <- S4Vectors::DataFrame(tf = sample(tf_set, 5e3, replace = TRUE))
gene_set <- expand.grid(LETTERS[1:10], LETTERS[1:10], LETTERS[1:10])
gene_set <- apply(gene_set,1,function(x) paste0(x,collapse=''))
regulon$target <- sample(gene_set, 5e3, replace = TRUE)
regulon$idxATAC <- 1:5e3
regulon$weight <- cbind(data.frame(C1 = runif(5e3), C2 = runif(5e3),
C3 = runif(5e3)))
plotDiffNetwork(regulon, tf = unique(tf_set)[1:3],
clusters = c('C1', 'C2', 'C3'), cutoff = 0.2)
}
\author{
Xiaosai Yao, Tomasz Wlodarczyk
}
