% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotHeatmapRegulon}
\alias{plotHeatmapRegulon}
\title{Plot targets genes of transcription factors in regulons}
\usage{
plotHeatmapRegulon(
  sce,
  tfs,
  regulon,
  regulon_column = "weight",
  regulon_cutoff = 0.1,
  downsample = 1000,
  scale = TRUE,
  center = TRUE,
  color_breaks = c(-2, 0, 2),
  colors = c("blue", "white", "red"),
  cell_attributes,
  col_gap = NULL,
  exprs_values = "logcounts",
  use_raster = TRUE,
  raster_quality = 10,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  border = TRUE,
  show_column_names = FALSE,
  column_col = NULL,
  row_col = NULL,
  genes_label = NULL,
  ...
)
}
\arguments{
\item{sce}{A SingleCellExperiment object containing information of cell attributes}

\item{tfs}{A character vector indicating the names of the transcription factors to be plotted}

\item{regulon}{A dataframe of regulons containing \code{tf}, \code{targets} and a column for filtering the regulons}

\item{regulon_column}{String indicating the column names to be used for filtering regulons}

\item{regulon_cutoff}{A scalar indicating the minimal value to retain the regulons for plotting}

\item{downsample}{Integer indicating the number of cells to sample from the matrix}

\item{scale}{Logical indicating whether to scale the heatmap}

\item{center}{Logical indicating whether to center the heatmap}

\item{color_breaks}{A vector indicating numeric breaks as input to \code{circlize::colorRamp2}}

\item{colors}{A vector of colors corresponding to values in \code{breaks} as input to \code{circlize::colorRamp2}}

\item{cell_attributes}{A character vector matching the column names of \code{colData(sce)} to be used for plotting}

\item{col_gap}{String indicating the cell attribute to split the columns of the heatmap by}

\item{exprs_values}{A string specifying which assay in \code{assays(object)} to obtain expression values from}

\item{use_raster}{Logical indicating whether to use rasterization to reduce image size}

\item{raster_quality}{Integer indicating the raster quality. The higher the value, the better the resolution}

\item{cluster_rows}{Logical indicating whether to cluster rows}

\item{cluster_columns}{Logical indicating whether to cluster columns}

\item{border}{Logical indicating whether to add border around heatmap}

\item{show_column_names}{Logical indicating whether to show column names}

\item{column_col}{A list specifying the colors in the columns.
See \href{https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#simple-annotation}{here}}

\item{row_col}{A list specifying the colors in the rows.
See \href{https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#simple-annotation}{here}}

\item{genes_label}{A character vector indicating a selected list of genes to show on the rownames}

\item{...}{other arguments for \code{ComplexHeatmap::Heatmap}}
}
\value{
A Heatmap-class object.
}
\description{
Plot targets genes of transcription factors in regulons
}
\examples{
example_sce <- scuttle::mockSCE()
example_sce <- scuttle::logNormCounts(example_sce)
example_sce$cluster <- sample(LETTERS[1:5], ncol(example_sce), replace = TRUE)
regulon <- data.frame(tf=c(rep('Gene_0001',10),rep('Gene_0002',20)),
target = sample(rownames(example_sce),30), weight = rnorm(30))
#plot heatmap and rotate labels
plotHeatmapRegulon(example_sce, tfs=c('Gene_0001','Gene_0002'), regulon=regulon,
cell_attributes='cluster', col_gap = 'cluster', column_title_rot = 90)
}
\author{
Xiaosai Yao
}
