% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAverageProfile.R
\name{plotAverageProfile}
\alias{plotAverageProfile}
\title{plotAverageProfile()}
\usage{
plotAverageProfile(
  rse,
  assay = NULL,
  x_labels = c("Before", "Anchor", "After"),
  palette = colorRampPalette(c("#DF536B", "black", "#61D04F")),
  alpha_for_se = 0.25,
  error_type = c("sd", "sem", "ci95"),
  reversed_z_order = FALSE,
  ylim = NULL,
  y_title = NULL,
  pattern = NULL
)
}
\arguments{
\item{rse}{a RangedSummarizedExperiment input. Aletrnatively: can be a
GRanges object
(for backward compatibility, \code{pattern} will be required).}

\item{assay}{specify the name of the assay to plot,
that should match one of \code{assayNames(rse)}.}

\item{x_labels}{x-axis labels.}

\item{palette}{A vector of colors, or a function that returns
a palette of \code{n} colors.}

\item{alpha_for_se}{the transparency (alpha) value for
the error band.}

\item{error_type, }{can be either \code{"sd"} (standard deviation),
\code{"sem"} (standard error of the mean),
or \code{"ci95"} (95\% confidence interval). Default: \code{"sd"}.}

\item{reversed_z_order}{should the z-order of the curves be reversed
(i.e. first or last bin on top?)}

\item{ylim}{a vector of two numbers corresponding
to the y-limits of the plot.}

\item{y_title}{the y-axis title.}

\item{pattern}{only if \code{rse} is of class GRanges.
A single character that should match
metadata of \code{rse} (can be a regular expression).}
}
\value{
Display a plot.
}
\description{
Plot the average stack profiles +/-  error (sd or sem).
If a \code{bin} column is present in \code{rowRanges(rse)},
one average profile is drawn for each bin.
}
\examples{
data("stackepi")
plotAverageProfile(stackepi)

}
