% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMetric.R
\name{plotMetric}
\alias{plotMetric}
\title{plotMetric()}
\usage{
plotMetric(
  x,
  trans_func = function(x) x,
  title = "Metric",
  ylim = NULL,
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{x}{a numeric vector.}

\item{trans_func}{a function to transform \code{x} values before ploting.
Useful to apply log10 transformation
(i.e. with \code{trans_func = function(x) log10(x+1)}).}

\item{title}{Title of the plot.}

\item{ylim}{limit of the y axis; format: \code{ylim = c(min, max)}}

\item{xlab}{x-axis title}

\item{ylab}{y-axis title}
}
\value{
Display a plot.
}
\description{
Plot a vertical line chart of the metric column,
in the same order as the input.
}
\examples{
data("stackepi")
plotMetric(SummarizedExperiment::rowRanges(stackepi)$exp)

}
\seealso{
\code{\link[epistack]{plotEpistack}},
\code{\link[epistack]{plotBoxMetric}}
}
