% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichIt.R
\name{enrichIt}
\alias{enrichIt}
\title{Flexible GSEA for Precomputed Gene Lists}
\usage{
enrichIt(
  input.data,
  gene.sets,
  gene_col = NULL,
  logFC_col = "avg_log2FC",
  pval_col = c("p_val_adj", "p_val"),
  ranking_fun = c("signed_log10_p", "logFC"),
  pval_cutoff = 1,
  logFC_cutoff = 0,
  minSize = 5,
  maxSize = 500,
  padjust_method = "BH",
  nproc = 0
)
}
\arguments{
\item{input.data}{Either:
\itemize{
  \item A named numeric vector \strong{already ranked}, or
  \item A data.frame/tibble with one row per gene and columns containing
    log-fold-change and p-value. If the gene ID is not in
    \code{rownames(data)}, supply \code{gene_col}.
}}

\item{gene.sets}{A named list of character vectors, the result of
\code{\link{getGeneSets}}, or the built-in data object
\code{\link{escape.gene.sets}}.}

\item{gene_col}{Character or \code{NULL}. Name of the column holding gene
identifiers (ignored when they are row-names). Default is \code{NULL}.}

\item{logFC_col}{Character. Column name for log-fold-change values. Default
is \code{"avg_log2FC"} (matches Seurat's \code{FindMarkers()}).}

\item{pval_col}{Character. Column name for p-values (or adjusted p-values).
Default is \code{c("p_val_adj", "p_val")} (first match is used).}

\item{ranking_fun}{Character. How to build the ranking:
\itemize{
  \item \code{"signed_log10_p"} (default): sign(logFC) * -log10(p).
  \item \code{"logFC"}: Use log-fold-change values directly.
}}

\item{pval_cutoff}{Numeric. Filter genes with p-value above this threshold
\strong{before} ranking. Default is \code{1} (no filtering).}

\item{logFC_cutoff}{Numeric. Filter genes with absolute log-fold-change
below this threshold \strong{before} ranking. Default is \code{0} (no
filtering).}

\item{minSize}{Integer. Minimum pathway size passed to \pkg{fgsea}. Default
is \code{5}.}

\item{maxSize}{Integer. Maximum pathway size passed to \pkg{fgsea}. Default
is \code{500}.}

\item{padjust_method}{Character. Multiple-testing correction method; any
method accepted by \code{\link[stats]{p.adjust}}. Default is \code{"BH"}.}

\item{nproc}{Integer. Passed to \pkg{fgsea}. Use \code{0} for multithread
if OpenMP is available. Default is \code{0}.}
}
\value{
`data.frame` with the usual fgsea columns plus a convenient
`leadingEdge` character column collapsed with \";\".
}
\description{
A convenience front-end to \pkg{fgsea} that lets you point at the
\code{avg_log2FC} and \code{p_val_adj} columns coming out of Seurat / DESeq2
/ edgeR etc. It converts them to a signed -log10(p) ranking, filters on
significance / effect size, and then runs fgsea.
}
\examples{
pbmc_small <- SeuratObject::pbmc_small

Seurat::Idents(pbmc_small) <- "groups"
markers <- Seurat::FindMarkers(pbmc_small, 
                               ident.1 = "g1", 
                               ident.2 = "g2")

gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
               
gsea <- enrichIt(markers, 
                 gene.sets = gs)

}
\seealso{
\code{\link[fgsea]{fgsea}}, \code{\link{getGeneSets}},
  \code{\link{gseaEnrichment}}
}
