% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsAnalysis.R
\name{getOptimalKValue}
\alias{getOptimalKValue}
\title{Calculating the optimal value of k.
getOptimalKValue}
\usage{
getOptimalKValue(stabData, qualData, k.range = NULL)
}
\arguments{
\item{stabData}{An output \code{\link{ExperimentList}} from
a \code{\link{stabilityRange}} execution.}

\item{qualData}{An output \code{\link{SummarizedExperiment}} from
a \code{\link{qualityRange}} execution.}

\item{k.range}{A range of K values to limit the scope of the
analysis.}
}
\value{
It returns a dataframe following the schema:
\code{metric}, \code{optimal_k}.
}
\description{
This method finds the optimal value of K per each metric.
}
\examples{
# Using example data from our package
data("rnaMetrics")
stabilityData <- stabilityRange(data=rnaMetrics, k.range=c(2,4), bs=20, getImages = FALSE)
qualityData <- qualityRange(data=rnaMetrics, k.range=c(2,4), getImages = FALSE)
kOptTable = getOptimalKValue(stabilityData, qualityData)


}
