% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{faers_merge}
\alias{faers_merge}
\alias{faers_merge,FAERSascii-method}
\alias{faers_merge,FAERSxml-method}
\alias{faers_merge,ANY-method}
\title{Merge all FAERS field data into one}
\usage{
faers_merge(object, ...)

\S4method{faers_merge}{FAERSascii}(object, fields = NULL, all = TRUE, all.x = all, all.y = all)

\S4method{faers_merge}{FAERSxml}(object)

\S4method{faers_merge}{ANY}(object)
}
\arguments{
\item{object}{A \link{FAERSascii} or \link{FAERSxml} object.}

\item{...}{Other arguments passed to specific methods.}

\item{fields}{A character vector specifying the fields to use. Only values
"demo", "drug", "indi", "ther", "reac", "rpsr", and "outc" can be used.}

\item{all}{logical; \code{all = TRUE} is shorthand to save setting both
\code{all.x = TRUE} and \code{all.y = TRUE}.}

\item{all.x}{logical; if \code{TRUE}, rows from \code{x} which have no matching row
in \code{y} are included. These rows will have 'NA's in the columns that are usually
filled with values from \code{y}. The default is \code{FALSE} so that only rows with
data from both \code{x} and \code{y} are included in the output.}

\item{all.y}{logical; analogous to \code{all.x} above.}
}
\value{
A \link[data.table:data.table]{data.table} object.
}
\description{
Merge all FAERS field data into one
}
\details{
Each pair of field data are merged based on "year", "quarter" and
"primaryid". In cases where any pair of data contains information related to
"drug_seq" elements, such as "drug_seq", "indi_drug_seq", or "dsg_drug_seq",
"drug_seq" will be aligned as well. \code{fields} shall be organized in the
subsequent sequence: 'demo', 'drug', 'indi', 'reac', 'ther', 'rpsr', and
'outc' and the merging sequence will correspondingly adhere to this order.
Only the initial instance, of the "caseid" column will be preserved.
}
\note{
You'd better only merge necessary data, otherwise a lot of memory will
be consumed to merge all fields data.
}
\examples{
# you must change `dir`, as the file included in the package is sampled
data <- faers(2004, "q1",
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
faers_merge(data, "indi") # only one field is just like faers_get()
faers_merge(data, c("demo", "indi"))
}
