/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.var;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Logger {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static boolean verbose = false;
    private static boolean lastWasCarret = false;

    public static void setVerbose(boolean v) {
        verbose = v;
    }

    public static void info(Object caller, String msg) {
        if (verbose) {
            Logger.info(caller, msg, System.err);
        }
    }

    public static void info(Object caller, String msg, PrintStream ps) {
        if (lastWasCarret) {
            ps.println();
            lastWasCarret = false;
        }
        if (verbose) {
            ps.println("[INFO]\t" + Logger.timestamp() + "\t" + caller.getClass().getSimpleName() + ": " + msg);
            ps.flush();
        }
    }

    public static void infoCarret(Object caller, String msg) {
        if (verbose) {
            Logger.infoCarret(caller, msg, System.err);
        }
    }

    public static void infoCarret(Object caller, String msg, PrintStream ps) {
        if (verbose) {
            ps.print("\u001b[2K\r[INFO]\t" + Logger.timestamp() + "\t" + caller.getClass().getSimpleName() + ": " + msg);
            ps.flush();
            lastWasCarret = true;
        }
    }

    public static void warn(Object caller, String msg) {
        Logger.warn(caller, msg, System.err);
    }

    public static void warn(Object caller, String msg, PrintStream ps) {
        ps.println("[WARN]\t" + Logger.timestamp() + "\t" + caller.getClass().getSimpleName() + ": " + msg);
        ps.flush();
    }

    public static void error(Object caller, String msg) {
        Logger.error(caller, msg, System.err);
    }

    public static void error(Object caller, String msg, PrintStream ps) {
        ps.println("[ERROR]\t" + Logger.timestamp() + "\t" + caller.getClass().getSimpleName() + ": " + msg);
        ps.flush();
    }

    public static void debug(Object caller, String msg) {
        if (verbose) {
            Logger.debug(caller, msg, System.err);
        }
    }

    public static void debug(Object caller, String msg, PrintStream ps) {
        if (verbose) {
            ps.println("[DEBUG]\t" + Logger.timestamp() + "\t" + caller.getClass().getSimpleName() + ": " + msg);
            ps.flush();
        }
    }

    public static String timestamp() {
        return Logger.timestamp(DATE_FORMAT);
    }

    public static String timestamp(SimpleDateFormat dataFormat) {
        return dataFormat.format(Calendar.getInstance().getTime());
    }
}

