% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedup.R
\name{runFedup}
\alias{runFedup}
\title{Runs pathway enrichment and depletion analysis using a Fisher's
exact test.}
\usage{
runFedup(genes, pathways)
}
\arguments{
\item{genes}{(list) named list of vectors with background genes and \code{n}
test genes.}

\item{pathways}{(list) named list of vectors with pathway annotations.}
}
\value{
List of length \code{n} with table(s) of pathway enrichment and
depletion results. Rows represent tested pathways. Columns represent:
\itemize{
    \item pathway -- name of the pathway, corresponds to
        names(\code{pathways});
    \item size -- size of the pathway;
    \item real_frac -- fraction of test gene members in pathway;
    \item expected_frac -- fraction of background gene members in
        pathway;
    \item fold_enrichment -- fold enrichment measure,
        evaluates as \code{real_frac} / \code{expected_frac};
    \item status -- indicator that pathway is enriched or depleted for
        test gene members;
    \item real_gene -- vector of test gene members annotated
        to \code{pathways};
    \item pvalue -- enrichment p-value calculated via Fisher's exact test;
    \item qvalue -- BH-adjusted p-value
}
}
\description{
This function takes a list of test genes and a common background
set to calculate enrichment and depletion for a list of pathways. The method
allows for fast and efficient testing of multiple gene sets of interest.
}
\examples{
# Load pathway annotations
data(pathwaysGMT)
# Run fedup with a single test set
data(geneSingle)
fedupRes <- runFedup(geneSingle, pathwaysGMT)
# Run fedup with two test sets
data(geneDouble)
fedupRes <- runFedup(geneDouble, pathwaysGMT)
# Run fedup with multiple test sets
data(geneMulti)
fedupRes <- runFedup(geneMulti, pathwaysGMT)
}
