% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathways.R
\name{writePathways}
\alias{writePathways}
\title{Writes a set of pathways (list of vectors) to a GMT file.}
\usage{
writePathways(pathways, gmtFile)
}
\arguments{
\item{pathways}{(list) named list of vectors}

\item{gmtFile}{(char) name of output GMT file}
}
\value{
GMT-formatted file. Rows represent pathways. Columns represent:
\itemize{
    \item pathway ID;
    \item description;
    \item a list of tab-delimited genes
}
}
\description{
Writes a set of pathways (list of vectors) to a GMT file.
}
\examples{
data(pathwaysXLSX)
writePathways(pathwaysXLSX, tempfile("pathwaysXLSX", fileext = ".gmt"))
}
