% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{fetch_go}
\alias{fetch_go}
\title{Get Gene Ontology (GO) data}
\usage{
fetch_go(
  species = NULL,
  dataset = NULL,
  use_cache = TRUE,
  on_error = c("stop", "warn", "ignore")
)
}
\arguments{
\item{species}{(Optional) Species designation. Examples are \code{goa_human}
for human, \code{mgi} for mouse, or \code{sgd} for yeast. Full list of
available species can be obtained using \code{fetch_go_species} - column
\code{designation}. This argument is used when fetching data from the Gene
Ontology database.}

\item{dataset}{(Optional) A string representing the dataset passed to
Ensebml's Biomart, e.g. 'scerevisiae_gene_ensembl'. To see the different
datasets available within a biomaRt you can e.g. do: mart <-
biomaRt::useEnsembl(biomart = "ensembl"), followed by
biomaRt::listDatasets(mart).}

\item{use_cache}{Logical, if TRUE, the remote data will be cached locally.}

\item{on_error}{A character string indicating the error handling strategy:
either "stop" to halt execution, "warn" to issue a warning and return
`NULL` or "ignore" to return `NULL` without warnings. Defaults to "stop".}
}
\value{
A list with \code{terms} and \code{mapping} tibbles.
}
\description{
This function downloads term information (GO term ID and name) and gene-term
mapping (gene ID, symbol, and GO term ID) from either the Ensembl database
(using BioMart) or the Gene Ontology database (using GAF files), depending on
the provided argument.
}
\details{
If \code{species} is provided, mapping from a Gene Ontology GAF file
  will be downloaded. GAF files contain more generic information than gene
  symbols. In this function, the third column of the GAF file (DB Object
  Symbol) is returned as \code{gene_symbol}, but, depending on the
  \code{species} argument it can contain other entities, e.g. RNA or protein
  complex names. Similarly, the eleventh column of the GAF file (DB Object
  Synonym) is returned as \code{gene_id}. It is up to the user to select
  the appropriate database.

  Alternatively, if \code{dataset} is provided, mapping will be downloaded
  from Ensembl database. It will gene symbol and Ensembl gene ID.
}
\examples{
# Fetch GO data from Ensembl
go_data_ensembl <- fetch_go(dataset = "scerevisiae_gene_ensembl", on_error = "warn")
# Fetch GO data from Gene Ontology
go_data_go <- fetch_go(species = "sgd", on_error = "warn")
}
