% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addXCMSPeaks.R
\name{addXCMSPeaks}
\alias{addXCMSPeaks}
\title{addXCMSPeaks}
\usage{
addXCMSPeaks(
  files,
  object,
  settings = list(),
  minintens = 100,
  minfeat = 6,
  BPPARAM = bpparam(),
  multipleMF = FALSE,
  multipleMFParam = list(fwhm = c(5, 10, 15), mz.abs = 0.2, rt.abs = 2)
)
}
\arguments{
\item{files}{list of chromatogram files}

\item{object}{a \code{peakDataset} object}

\item{settings}{see \code{\link[xcms]{findPeaks-matchedFilter}}
\code{\link[xcms]{findPeaks-centWave}}}

\item{minintens}{minimum ion intensity to be included into a pseudospectra}

\item{minfeat}{minimum number of ion to be created a pseudospectra}

\item{BPPARAM}{a parameter class specifying if and how parallel processing
should be performed}

\item{multipleMF}{logical Try to remove redundant peaks, in
this case where there are any peaks within an absolute m/z value of 0.2 and
within 3 s for any one sample in the xcmsSet (the largest peak is kept)}

\item{multipleMFParam}{list. It conteins the settings for the
peak-picking. mz_abs represent the the mz range; rt_abs represent thert range}

\item{mz.abs}{mz range}

\item{rt.abs}{rt range}
}
\value{
\code{peaksDataset} object
}
\description{
Add xcms/CAMERA peak detection results
}
\details{
Reads the raw data using xcms, group each extracted ion according to their
retention time using CAMERA and attaches them to an already created
\code{peaksDataset} object

Repeated calls to xcmsSet and annotate to perform peak-picking and
deconvolution. The peak detection results are added to the original
\code{peaksDataset} object. Two peak detection alorithms are available:
continuous wavelet transform (peakPicking=c('cwt')) and the matched filter
approach (peakPicking=c('mF')) described by Smith et al (2006). For further
information consult the xcms package manual.
}
\examples{
files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam()
data <- addXCMSPeaks(files[1:2], data, settings = mfp, multipleMF = FALSE)
data
}
\seealso{
\code{\link[xcms]{peaksDataset}} \code{\link[xcms]{findPeaks-matchedFilter}}
\code{\link[xcms]{findPeaks-centWave}} \code{\link[xcms]{xcmsRaw-class}}
}
\author{
Riccardo Romoli \email{riccardo.romoli@unifi.it}
}
\keyword{manip}
