% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betweenAlignment.R
\name{betweenAlignment}
\alias{betweenAlignment}
\alias{betweenAlignment-class}
\alias{betweenAlignment-show}
\alias{show,}
\alias{betweenAlignment-method}
\title{Data Structure for "between" alignment of many GCMS samples}
\usage{
betweenAlignment(
  pD,
  cAList,
  pAList,
  impList,
  filterMin = 1,
  gap = 0.7,
  D = 10,
  usePeaks = TRUE,
  df = 30,
  verbose = TRUE,
  metric = 2,
  type = 2,
  penality = 0.2,
  compress = FALSE
)
}
\arguments{
\item{pD}{a \code{peaksDataset} object}

\item{cAList}{\code{list} of \code{clusterAlignment} objects, one for each
experimental group}

\item{pAList}{\code{list} of \code{progressiveAlignment} objects, one for
each experimental group}

\item{impList}{\code{list} of imputation lists}

\item{filterMin}{minimum number of peaks within a merged peak to be kept in
the analysis}

\item{gap}{gap parameter}

\item{D}{retention time penalty parameter}

\item{usePeaks}{logical, whether to use peaks (if \code{TRUE}) or the full
2D profile alignment (if \code{FALSE})}

\item{df}{distance from diagonal to calculate similarity}

\item{verbose}{logical, whether to print information}

\item{metric}{numeric, different algorithm to calculate the similarity
matrix between two mass spectrum. \code{metric=1} call
\code{normDotProduct()}; \code{metric=2} call \code{ndpRT()};
\code{metric=3} call \code{corPrt()}}

\item{type}{numeric, two different type of alignment function}

\item{penality}{penalization applied to the matching between two mass
spectra if \code{(t1-t2)>D}}

\item{compress}{logical whether to compress the similarity matrix into a
sparse format.}
}
\value{
\code{betweenAlignment} object
}
\description{
This function creates a "between" alignment (i.e. comparing merged peaks)
}
\details{
\code{betweenAlignment} objects gives the data structure which stores the
result of an alignment across several "pseudo" datasets. These pseudo
datasets are constructed by merging the "within" alignments.
}
\examples{

	require(gcspikelite)
	## see 'multipleAlignment'
}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas
chromatography - mass spectrometry data \emph{PhD dissertation} University
of Melbourne.
}
\seealso{
\code{\link{multipleAlignment}}
}
\author{
Mark Robinson
}
\keyword{classes}
