% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp.R
\name{dynRT}
\alias{dynRT}
\title{dynRT}
\usage{
dynRT(S)
}
\arguments{
\item{S}{similarity matrix}
}
\value{
list containing the matched peaks between the two chromatograms. The
number represent position of the spectra in the S matrix
}
\description{
Dynamic Retention Time Based Alignment algorithm, given a similarity matrix
}
\details{
This function align two chromatograms finding the maximum similarity among
the mass spectra
}
\examples{

require(gcspikelite)
files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam()
data <- addXCMSPeaks(files[1:2], data, settings = mfp, multipleMF = FALSE)
data
## review peak picking
plotChrom(data, rtrange=c(7.5, 10.5), runs=c(1:2))
## similarity
r <- ndpRT(data@peaksdata[[1]], data@peaksdata[[2]], data@peaksrt[[1]],
    data@peaksrt[[2]], D = 50)
## dynamic retention time based alignment algorithm
v <- dynRT(S = r)

}
\author{
riccardo.romoli@unifi.it
}
