% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{normDotProduct}
\alias{normDotProduct}
\title{Normalized Dot Product}
\usage{
normDotProduct(
  x1,
  x2,
  t1 = NULL,
  t2 = NULL,
  df = max(ncol(x1), ncol(x2)),
  D = 1e+05,
  timedf = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x1}{data matrix for sample 1}

\item{x2}{data matrix for sample 2}

\item{t1}{vector of retention times for sample 1}

\item{t2}{vector of retention times for sample 2}

\item{df}{distance from diagonal to calculate similarity}

\item{D}{retention time penalty}

\item{timedf}{matrix of time differences to normalize to.  if \code{NULL}, 0
is used.}

\item{verbose}{logical, whether to print out information}
}
\value{
matrix of similarities
}
\description{
This function calculates the similarity of all pairs of peaks from 2
samples, using the spectra similarity
}
\details{
Efficiently computes the normalized dot product between every pair of peak
vectors and returns a similarity matrix.  C code is called.
}
\examples{

require(gcspikelite)

# paths and files
gcmsPath<-paste(find.package("gcspikelite"),"data",sep="/")
cdfFiles<-dir(gcmsPath,"CDF",full=TRUE)
eluFiles<-dir(gcmsPath,"ELU",full=TRUE)

# read data, peak detection results
pd<-peaksDataset(cdfFiles[1:2],mz=seq(50,550),rtrange=c(7.5,8.5))
pd<-addAMDISPeaks(pd,eluFiles[1:2])

r<-normDotProduct(pd@peaksdata[[1]],pd@peaksdata[[2]])

}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas chromatography -
mass spectrometry data \emph{PhD dissertation} University of Melbourne.
}
\seealso{
\code{\link{dp}}, \code{\link{peaksAlignment}}
}
\author{
Mark Robinson
}
\keyword{manip}
