% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaksAlignment.R
\name{plotAlignment,peaksAlignment-method}
\alias{plotAlignment,peaksAlignment-method}
\title{plotAlignment}
\usage{
\S4method{plotAlignment}{peaksAlignment}(
  object,
  xlab = "Peaks - run 1",
  ylab = "Peaks - run 2",
  plotMatches = TRUE,
  matchPch = 19,
  matchLwd = 3,
  matchCex = 0.5,
  matchCol = "black",
  col = colorpanel(50, "white", "green", "navyblue"),
  breaks = seq(0, 1, length = 51),
  ...
)
}
\arguments{
\item{object}{a \code{clusterAlignment} object}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{plotMatches}{logical, whether to plot matches}

\item{matchPch}{match plotting character}

\item{matchLwd}{match line width}

\item{matchCex}{match character expansion factor}

\item{matchCol}{match colour}

\item{col}{vector of colours for colourscale}

\item{breaks}{vector of breaks for colourscale}

\item{...}{further arguments passed to \code{image}}
}
\value{
plot an object of class \code{\linkS4class{peaksAlignment}}
}
\description{
Plotting functions for GCMS data objects
}
\details{
Plot an object of \code{\linkS4class{peaksAlignment}}

The similarity matrix is plotted and optionally, the set of matching peaks.
\code{clusterAlignment} objects are just a collection of all pairwise
\code{peakAlignment} objects.
}
\examples{

require(gcspikelite)
files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam(snthresh = 3, ppm = 3000, peakwidth = c(3, 40),
 prefilter = c(3, 100), fitgauss = FALSE, integrate = 2, noise = 0,
 extendLengthMSW = TRUE, mzCenterFun = "wMean")
data <- addXCMSPeaks(files[1:2], data, settings = mfp)
data
## image plot
plotChrom(data, rtrange = c(7.5,8.5), plotPeaks = TRUE, plotPeakLabels =TRUE)

## align two chromatogram
pA <- peaksAlignment(data@peaksdata[[1]], data@peaksdata[[2]],
                     data@peaksrt[[1]], data@peaksrt[[2]], D = 50,
                     compress = FALSE, type = 1, metric = 1,
                     gap = 0.5)
plotAlignment(pA)

}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas
chromatography - mass spectrometry data \emph{PhD dissertation} University
of Melbourne.
}
\seealso{
\code{\link{peaksAlignment}} \code{\link{plotAlignment}}
}
\author{
Mark Robinson
}
\keyword{classes}
