% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{logarithm-class}
\alias{logarithm-class}
\alias{logarithm}
\alias{eval,logarithm,missing-method}
\title{Class "logarithm"}
\description{
Logartithmic transform class, which represents a transformation defined by
the function
}
\details{
\deqn{f(parameter,a,b)= ln(a*prarameter)*b ~~~~a*parameter>0} \deqn{0
~~~~a*parameter<=0}
}
\section{Slots}{

\describe{
\item{\code{.Data}}{Object of class \code{"function"}}

\item{\code{a}}{Object of class \code{"numeric"} -- non-zero multiplicative constant.}

\item{\code{b}}{Object of class \code{"numeric"} -- non-zero multiplicative constant.}

\item{\code{parameters}}{Object of class \code{"transformation"} -- flow parameters to be transformed.}

\item{\code{transformationId}}{Object of class \code{"character"} -- unique ID to reference the transformation.}
}}

\note{
The logarithm transformation object can be evaluated using the eval
method by passing the data frame as an argument.The transformed parameters
are returned as a matrix with a single column. (See example below)
}
\section{Objects from the Class}{
 Objects can be created by calls to the
constructor \code{logarithm(parameters,a,b,transformationId)}
}

\section{Extends}{

Class \code{"\linkS4class{singleParameterTransform}"}, directly.

Class \code{"\linkS4class{transform}"}, by class "singleParameterTransform", distance 2.

Class \code{"\linkS4class{transformation}"}, by class "singleParameterTransform", distance 3.

Class \code{"\linkS4class{characterOrTransformation}"}, by class "singleParameterTransform", distance 4.
}

\examples{

 dat <- read.FCS(system.file("extdata","0877408774.B08",
  package="flowCore"))
  lg1<-logarithm(parameters="FSC-H",a=2,b=1,transformationId="lg1")
  transOut<-eval(lg1)(exprs(dat))

}
\references{
Gating-ML Candidate Recommendation for Gating Description in
Flow Cytometry V 1.5
}
\seealso{
exponential, quadratic

Other mathematical transform classes: 
\code{\link{EHtrans-class}},
\code{\link{asinht-class}},
\code{\link{asinhtGml2-class}},
\code{\link{dg1polynomial-class}},
\code{\link{exponential-class}},
\code{\link{hyperlog-class}},
\code{\link{hyperlogtGml2-class}},
\code{\link{invsplitscale-class}},
\code{\link{lintGml2-class}},
\code{\link{logicletGml2-class}},
\code{\link{logtGml2-class}},
\code{\link{quadratic-class}},
\code{\link{ratio-class}},
\code{\link{ratiotGml2-class}},
\code{\link{sinht-class}},
\code{\link{splitscale-class}},
\code{\link{squareroot-class}},
\code{\link{unitytransform-class}}
}
\author{
Gopalakrishnan N, F.Hahne
}
\concept{mathematical transform classes}
\keyword{classes}
