% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_flowGraphSubset_constructor.R
\name{flowGraphSubset}
\alias{flowGraphSubset}
\title{flowGraph object constructor.}
\usage{
flowGraphSubset(
  input_,
  meta = NULL,
  class = "class",
  no_cores = 1,
  markers = NULL,
  layout_fun = "layout.reingold.tilford",
  max_layer = NULL,
  cumsumpos = FALSE,
  path = NULL,
  summary_pars = flowGraphSubset_summary_pars(),
  summary_adjust = flowGraphSubset_summary_adjust(),
  save_plots = TRUE
)
}
\arguments{
\item{input_}{a numeric matrix of the cell counts;
its column/names must be the phenotype names and its rownames
must be sample ID's.}

\item{meta}{A data frame with meta data for each \code{Phenotypes} or sample;
One of its column names should be "id" whose values correspond to
the name of each \code{Phenotypes} object. We also recommend for it to have
a column named "class" where one of its unique values is "control".}

\item{class}{A string corresponding to the column name or index
of \code{meta} whose values represent
the class label of each sample, Default: 'class'}

\item{no_cores}{An integer indicating how many cores to parallelize on,
Default: 1}

\item{markers}{A string vector of marker names used in \code{input_},
Default: NULL}

\item{layout_fun}{A string of a function from the \code{igraph} package that
indicates what layout should be used if a cell hierarchy is to be ploted;
all such functions have prefix \code{layout_}. This is defaulted to
e.g. \code{layout_fun="layout.reingold.tilford"}.}

\item{max_layer}{And integer indicating the maximum layer in the cell
hierarchy to analyze; set to `NULL` to analyze all layers.}

\item{cumsumpos}{A logical variable indicating whether
or not to cumulate cell counts;
this applies only when \code{partitionsPerMarker > 3} and will convert
e.g. the count of A+ or A++ into the sum of the counts of
A+, A++, A+++, ..., or A++, A+++, ... , Default: FALSE}

\item{path}{A string indicating the folder path to where the flowGraph
object should save its elements, Default = NULL (don't save).}

\item{summary_pars}{A list containing parameters for calculating the
 statistical significance summary significance that will determine whether
 to trim out phenotypes for this fast version of flowGraph. The lists'
 elements are:
\itemize{
  \item{\code{node_feature}: "SpecEnr"; this is the feature we will be
   testing, don't change this.}
  \item{\code{edge_feature}: "NONE"; this unneeded for now.}
  \item{\code{test_name}: "t_diminish"; this unneeded for now.}
  \item{\code{test_custom}: "t"; a string or a function indicating the
   statistical test desires. These tests can be
   \code{c("t", "wilcox","ks","var","chisq")} corresponding to functions
   \code{\link[stats]{t.test}},\code{\link[stats]{wilcox.test}},
   \code{\link[stats]{ks.test}},\code{\link[stats]{var.test}},
   \code{\link[stats]{chisq.test}}}
  \item{\code{diminish}: TRUE; whether or not to continue testing
   phenotypes whos parent phenotypes are all insignificant.}
  \item{\code{class}: "class"; the column name in \code{meta} that contains
   class labels you want to test.}
  \item{\code{labels}: c("aml", "control") for the flowcap data set;
  SET THIS!! to the class labels you want to test using \code{test_custom}.}
}}

\item{summary_adjust}{A list of parameters on how to adjust the p-values;
 this also affects which phenotypes are tested. The elements in the list are:
\itemize{
  \item{\code{adjust_custom}: "byLayer"; this is a string (corresponding to
   an option in \code{\link[stats]{p.adjust}}) or a function used to
   adjust p-values.}
  \item{\code{btwn_test_custom}: "t"; see \code{test_custom} in
   \code{summary_pars}; this statistical significance test is used in
   the filters.}
  \item{\code{adjust0_lim}: see \code{fg_get_summary}.}
  \item{\code{filter_adjust0}: see \code{fg_get_summary}.}
  \item{\code{filter_es}: see \code{fg_get_summary}.}
  \item{\code{filter_btwn_tpthres}: see \code{fg_get_summary}.}
  \item{\code{filter_btwn_es}: see \code{fg_get_summary}.}
}}

\item{save_plots}{A logical indicating whether or not to save plots.}
}
\value{
flowGraph object
}
\description{
Initializes a \code{flowGraph} object given the cell counts
 for one or more flow cytometry sample(s).
 The flowGraph object returned holds meta data
 for each sample, each cell population node,
 edges representing how each cell population node relate to one another,
 and features for these nodes and edges.
}
\details{
All node and edge features are trimmed such that only the
 significant phenotypes are left; the original input is stored in the slot
 \code{etc$original_count} of the returned flowGraph object.
}
\examples{
\dontrun{
if(interactive()){
  data(fg_data_pos2)
  fg <- flowGraph(fg_data_pos2$count, meta=fg_data_pos2$meta, no_cores=1)
 }
}
}
