% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{fhAccessors}
\alias{fhAccessors}
\alias{fhGate}
\alias{fhLimits}
\alias{fhSamples}
\alias{fhTrimRaw}
\alias{fhPeaks}
\alias{fhInit}
\alias{fhComps}
\alias{fhModel}
\alias{fhSpecialParams}
\alias{fhArgs}
\alias{fhNLS}
\alias{fhCounts}
\alias{fhCV}
\alias{fhRCS}
\alias{fhFile}
\alias{fhChannel}
\alias{fhBins}
\alias{fhLinearity}
\alias{fhDebris}
\alias{fhHistData}
\alias{fhRaw}
\alias{fhStandards}
\alias{fhStdPeak}
\alias{fhStdSelected}
\alias{fhStdSizes}
\alias{fhOpts}
\alias{fhG2}
\alias{fhAnnotation}
\alias{fhFail}
\title{FlowHist Accessors}
\usage{
fhGate(fh)

fhLimits(fh)

fhSamples(fh)

fhTrimRaw(fh)

fhPeaks(fh)

fhInit(fh)

fhComps(fh)

fhModel(fh)

fhSpecialParams(fh)

fhArgs(fh)

fhNLS(fh)

fhCounts(fh)

fhCV(fh)

fhRCS(fh)

fhFile(fh)

fhChannel(fh)

fhBins(fh)

fhLinearity(fh)

fhDebris(fh)

fhHistData(fh)

fhRaw(fh)

fhStandards(fh)

fhStdPeak(fh)

fhStdSelected(fh)

fhStdSizes(fh)

fhOpts(fh)

fhG2(fh)

fhAnnotation(fh)

fhFail(fh)
}
\arguments{
\item{fh}{a \code{\link{FlowHist}}}
}
\value{
Used to access a slot, returns the value of the slot. Used to
  update the value of a slot, returns the updated \code{\link{FlowHist}}
  object.
}
\description{
Functions to access slot values in \code{\link{FlowHist}} objects
}
\details{
For normal users, these functions aren't necessary. Overly curious
users, or those wishing to hack on the code, may find these useful for
inspecting the various bits and pieces inside a \code{\link{FlowHist}}
object.

The versions of these functions that allow modification of the
\code{\link{FlowHist}} object are not exported. Functions are provided
for users to update \code{\link{FlowHist}} objects in a safe way.
}
\examples{
library(flowPloidyData) 
fh1 <- FlowHist(file = flowPloidyFiles()[1], channel = "FL3.INT.LIN")
fhModel(fh1) ## prints the model to screen
}
\author{
Tyler Smith
}
