% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowSet2LongDf.R
\name{flowSet2LongDf}
\alias{flowSet2LongDf}
\title{Convert a flowSet to one long dataframe with all identifiers as separate
#columns.}
\usage{
flowSet2LongDf(flowObj, idInfo)
}
\arguments{
\item{flowObj}{The flowSet or flowFrame to be converted to a dataframe.}

\item{idInfo}{A list of any number of characteristics that can be derived
from the file names. For each entry, a gsub specification of where to find
the information in the file name should be added, such as id=""..._|..."".}
}
\value{
A long data frame with one column per PMT/APD (or fluorochrome,
depending on the state of the imported files), one for the acquisition date
(for fcs files) and one colum for each specified slot above. If no
gsub-pattern is provided, only a single column with the full file name will
be used to separate the observations from each file.
}
\description{
This function is mainly used for compatibility with matrix-based clustering
algorithms, such as depeche in the DepecheR package.
}
\examples{
#' # Load uncompensated data
data(fullPanel)

# Load the spectral unmixing matrix generated with controls from the same
# experiment. These can be generated using the specMatCalc function.
data(specMat)

# Now unmix
fullPanelUnmix <- specUnmix(fullPanel, specMat)

# Transform all fluorescent channels
fullPanelTrans <- arcTrans(fullPanelUnmix,
    transNames = colnames(fullPanelUnmix)[6:18])

# This function is primarily meant to be used with flowSets.
# If we had only one flowFrame, we could just extract the data by
# the use of the flowCore function exprs(), so we will convert the data to a
# flowSet now.
library(flowCore)
fullPanelFs <- flowSet(fullPanelTrans)

# Before converting to a dataframe it is important to get an idea of the
# structure of the names, to be able to extract meaningful parts of the name.
# Here, we have an exceptional case again, as the flowSet has just been
# created, so there is actually no meaningful name of the flowFrame inside
# it. So for example reasons, we will give it one now:
sampleNames(fullPanelFs) <- "PBMC_full_panel_d1.fcs"

# And now, we generate the dataframe:
fullPanelDf <- flowSet2LongDf(fullPanelFs, idInfo =
                                 list("Tissue" = "|_full_panel_..\\\\.fcs",
                                     "Donor" = "...._full_panel_|\\\\.fcs"))
# This is the result
str(fullPanelDf)

}
\seealso{
\code{\link[DepecheR]{depeche}}
}
