       
\name{calcPearsonChi}
\alias{calcPearsonChi}

\title{ Pearsons chi-square statistic for comparing the probability 
binned datasets}

\description{
This function calculates the Pearsons chi-squared statistic for comparing 
data binned using the \code{proBin} and \code{binByRef} functions.Internally, the 
function utilizes the chisq.test function.
}

\usage{
calcPearsonChi(ctrlRes,sampRes)
}

\arguments{
  
  \item{ctrlRes}{ The result generated by calling the \code{probBin}
    function on a control dataset.}

  \item{sampRes}{ The result generated by calling the \code{byByRef}
    function on a sample dataset}
  
}
\value{

  A list containing the statistic, p.value, observed, expected counts
  and the residuals

}

\author{Nishant Gopalakrishnan}

\seealso{ \code{\link{proBin}}, \code{\link{calcPBChiSquare}}}

\examples{
library(flowCore)
data(GvHD)
# flow frame 1 is treated as  control dataset and used to generate bins
resCtrl<-proBin(GvHD[[1]][,c("FSC-H","SSC-H","Time")],200)  
plotBins(resCtrl,GvHD[[1]],channels=c("FSC-H","SSC-H","Time"),title="Binned control data")
# Same bins are applied to flowFrame 16
resSample<-binByRef(resCtrl,GvHD[[16]][,c("FSC-H","SSC-H","Time")])
stat<-calcPearsonChi(resCtrl,resSample)
}

\keyword{misc}