% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowPlot.R
\docType{methods}
\name{flowPlot}
\alias{flowPlot}
\alias{flowPlot,flowFrame-method}
\title{Standard Plots for Flow Cytometry Data}
\usage{
\S4method{flowPlot}{flowFrame}(x, child, filter = NULL,
  plotParameters = c("FSC-H", "SSC-H"), logx = FALSE, logy = FALSE,
  parent, colParent = "Grey", colChild = "Blue", showFilter = TRUE,
  gate.fill = "transparent", gate.border = "black", xlab, ylab, xlim,
  ylim, ...)
}
\arguments{
\item{x}{An object of class \code{flowFrame} that contains the data to be
plotted.}

\item{child}{An optional argument of class \code{filterResult} that
specifies a subset of the data that are included in the \code{filterResult}}

\item{filter}{A \code{filter}, \code{filterResult} or
\code{filterResultList} object.}

\item{plotParameters}{A vector of charactors defining the x and y variables
in terms of columns in the data.}

\item{logx, logy}{Logical controlling wheterh the corresponding variables
will be log transfromed before passing to the panel function. Default to
\code{FALSE}.}

\item{parent}{An optional argument of class \code{filterResult} that
specifies a subset of the data that are inclueed in the \code{filterResult}.}

\item{colParent}{Specifying the color for \code{parent}. See \code{parent}
above.}

\item{colChild}{Specifies the color for \code{child}. See \code{chile}
above.}

\item{showFilter}{Logical, specifying whether to show the \code{filter}.}

\item{gate.fill}{Specifies the fill color of the gate. Default to
\code{transparent}.}

\item{gate.border}{Character or specifying the color of the gate border.
Default to \code{black}.}

\item{xlab, ylab}{Labels for data axes.}

\item{xlim, ylim}{Numeric vectors of length 2 specifying axis limits.}

\item{\dots}{More arguments, usually passed on to the underlying lattice
methods.}
}
\description{
A method that makes standard plots from a \code{flowFrame}. The user may
also provide various \code{filter} or \code{filterResult} arguments to
customize the plot.
}
\details{
The plot that is most commonly used in flow cytometry data analysis is
usuall called a "dot plot". In common statistical language, we would call
this a scatter plot. The basic idea is a 2-dimensional plot that shows the
location of every cell in regard to the measurements made on it, for
example, forward scatter vs side scatter. Most applications will, in
addition to the data, want to show information about one or more filters
(gates). Since there can be a very large number of cells in a sample, it is
common to show a smoothed version of the data that doesn't involve
registering every point on the graph.
}
\examples{

library(flowCore)
data(GvHD)
flowPlot(GvHD[["s5a01"]])
flowPlot(transform("SSC-H"=asinh,"FSC-H"=asinh) \%on\% GvHD[["s5a01"]])


}
\seealso{
\code{\link[flowCore:flowCore-package]{flowCore}}
}
\author{
P. Haaland
}
\keyword{methods}
