% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,flowFrame,missing-method}
\alias{plot,flowFrame,character-method}
\title{Very basic plotting of flowFrames}
\usage{
\S4method{plot}{flowFrame,missing}(x, y, smooth = TRUE, ...)

\S4method{plot}{flowFrame,character}(x, y, smooth = TRUE, pch, ...)
}
\arguments{
\item{x}{flowFrame}

\item{y}{(optional) channel names}

\item{smooth}{logical}

\item{...}{other arguments}

\item{pch}{point type}
}
\description{
A basic method to plot \code{\link[flowCore:flowFrame-class]{flowFrame}}
objects. Depending on the number of dimensions, different types of plots are
generates. See below for details.
}
\details{
Basic plots for \code{flowFrame} objects. If the object has only a single
parameter this produces a \code{\link[graphics:hist]{histogram}}. For
exactly two parameters we plot a bivariate density map (see
\code{\link[graphics]{smoothScatter}}) and for more than two parameters we
produce a simple \code{\link[lattice]{splom}} plot. To select specific
parameters from a \code{flowFrame} for plotting, either subset the object or
specify the parameters as a character vector in the second argument to
\code{plot}. The \code{smooth} parameters lets you toggle between
density-type \code{\link[graphics]{smoothScatter}} plots and regular scatter
or pairs plots.  For far more sophisticated plotting of flow cytometry data,
see the lattice-style plot methods provided by this package.
}
\seealso{
\code{\link[flowViz]{xyplot}},
\code{\link[flowCore:flowFrame-class]{flowFrame}},
\code{\link[flowViz]{densityplot}}
}
\author{
F. Hahne
}
\keyword{methods}
