% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{add.contours}
\alias{add.contours}
\title{Add object contours to a \code{Frames} object

Creates a \code{Frames} object containing raw information, combined with the segmented
images and the relative trajectory under analysis}
\usage{
add.contours(
  raw.frames,
  binary.frames = NULL,
  trajectoryset = NULL,
  trajIDs = NULL,
  mode = "particles",
  col = NULL,
  channel = NULL
)
}
\arguments{
\item{raw.frames}{A \code{Frames} object with raw images}

\item{binary.frames}{A \code{Frames} object with preprocessed frames}

\item{trajectoryset}{A \code{TrajectorySet} object}

\item{trajIDs}{Numeric vector, the ID(s) of the trajectory.}

\item{mode}{A character string, can assume the values \code{particles} or \code{trajectories}.
Defaults to \code{particles}}

\item{col}{A vector of color strings}

\item{channel}{A character string, to select which channel to process}
}
\value{
A new \code{Frames} object with contours of the objects added
}
\description{
If a \code{TrajectorySet} is provided and mode is set to \code{trajectories}, returns
a \code{Frames} with all trajectories included in the IDs
vector painted accordingly.
If the mode is set to \code{particles}, it will just plot the particles (all) on all frames.
If no \code{TrajectorySet} is provided, it will be computed with default parameters.
If no \code{binary.frames} is provided, it will be computed also with default parameters
}
\examples{
data("MesenteriumSubset")
\dontrun{
paintedTrajectories <- add.contours(raw.frames = MesenteriumSubset, 
                                    mode = "trajectories",channel="red")
paintedParticles <- add.contours(raw.frames = MesenteriumSubset, 
                                 mode = "particles",channel="red")
inspect.Frames(paintedTrajectories)
inspect.Frames(paintedParticles)
}

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
