% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{plot2D.TrajectorySet}
\alias{plot2D.TrajectorySet}
\title{2D projection of a \code{TrajectorySet} object}
\usage{
plot2D.TrajectorySet(
  trajectoryset,
  frames,
  trajIDs = NULL,
  addGrid = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{trajectoryset}{A \code{TrajectorySet} object}

\item{frames}{A \code{Frames} object, used here to identify the limits of the region of interest}

\item{trajIDs}{A vector containing the ids of the desired trajectories}

\item{addGrid}{Logical, add an additional grid to the 2-dimensional plot (visual aid for backtracking trajectory point locations)}

\item{verbose}{Logical, whether to provide additional output on the command line}

\item{...}{Arguments to be passed to methods}
}
\value{
\code{plot2D.TrajectorySet} returns an invisible \code{NULL}.
}
\description{
Provides a bird's eye view of a \code{TrajectorySet} object on a bidimensional space
}
\details{
This function extracts the region of interests from the dimensions
of an image of the \code{Frames} object,
and afterwards plots the x-y-time representation of the identified
trajectories on a 2d plane. It is possible to subset the \code{TrajectorySet}
object with the IDs of the desired trajectories
}
\examples{
data("MesenteriumSubset")
data("candidate.platelets")
platelets.trajectories <- trajectories(candidate.platelets)
plot2D.TrajectorySet(platelets.trajectories,MesenteriumSubset)

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
