% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{snap}
\alias{snap}
\title{Snap the features of the closest particle identified}
\usage{
snap(
  raw.frames,
  binary.frames,
  particleset,
  trajectoryset,
  frameID = 1,
  infocol = "yellow",
  infocex = 1,
  showVelocity = FALSE
)
}
\arguments{
\item{raw.frames}{A \code{Frames} object with the raw frames data}

\item{binary.frames}{A \code{Frames} object with the preprocessed frames data}

\item{particleset}{A \code{ParticleSet} object with the particles data}

\item{trajectoryset}{A \code{TrajectorySet} object with the trajectories data}

\item{frameID}{The ID of the frame to inspect}

\item{infocol}{The color to use for plotting the contours and the information on the
clicked particle}

\item{infocex}{The numeric character expansion value as in \code{cex} to be used
for printing the text on the image}

\item{showVelocity}{Logical, whether to display additional information on the
instantaneous velocity of the particle}
}
\value{
An image of the selected frame, rendered in R native graphics, and additionally
a list with the coordinates as well as the trajectory ID of the particle closest to the
clicked location
}
\description{
This function combines all classes related to a single experiment in order to deliver
a clickable feedback on one of the frames.
}
\examples{
\dontrun{data(MesenteriumSubset)
binary.frames <- preprocess.Frames(channel.Frames(MesenteriumSubset,"red"))
particleset <- particles(MesenteriumSubset,binary.frames,"red")
trajectoryset <- trajectories(particleset)
snap(MesenteriumSubset,binary.frames,particleset,trajectoryset,frameID=1)
}
}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2015
}
