% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{fmrs.varsel}
\alias{fmrs.varsel}
\alias{fmrs.varsel,ANY-method}
\alias{fmrs.varsel-method}
\title{fmrs.varsel method}
\usage{
fmrs.varsel(y, delta, x, nComp, ...)

\S4method{fmrs.varsel}{ANY}(
  y,
  delta,
  x,
  nComp,
  disFamily = "lnorm",
  initCoeff,
  initDispersion,
  initmixProp,
  penFamily = "lasso",
  lambPen,
  lambRidge = 0,
  nIterEM = 2000,
  nIterNR = 2,
  conveps = 1e-08,
  convepsEM = 1e-08,
  convepsNR = 1e-08,
  NRpor = 2,
  gamMixPor = 1,
  activeset,
  lambMCP,
  lambSICA,
  cutpoint = 0.05
)
}
\arguments{
\item{y}{Responses (observations)}

\item{delta}{Censoring indicators}

\item{x}{Design matrix (covariates)}

\item{nComp}{Order (Number of components) of mixture model}

\item{...}{Other possible options}

\item{disFamily}{A sub-distribution family. The options
are \code{'norm'} for \code{FMR} models, \code{'lnorm'} for mixture of
AFT regression models with Log-Normal sub-distributions, \code{'weibull'}
for mixture of AFT regression models with Weibull sub-distributions}

\item{initCoeff}{Vector of initial values for regression coefficients
including intercepts}

\item{initDispersion}{Vector of initial values for standard deviations}

\item{initmixProp}{Vector of initial values for proportion of components}

\item{penFamily}{Penalty name that is used in variable selection method
The available options are  \code{'lasso'}, \code{'adplasso'},
\code{'mcp'}, \code{'scad'}, \code{'sica'} and \code{'hard'}.}

\item{lambPen}{A vector of positive numbers for tuning parameters}

\item{lambRidge}{A positive value for tuning parameter in Ridge
Regression or Elastic Net}

\item{nIterEM}{Maximum number of iterations for EM algorithm}

\item{nIterNR}{Maximum number of iterations for Newton-Raphson algorithm}

\item{conveps}{A positive value for avoiding NaN in computing divisions}

\item{convepsEM}{A positive value for threshold of convergence in
EM algorithm}

\item{convepsNR}{A positive value for threshold of convergence in
NR algorithm}

\item{NRpor}{A positive interger for maximum number of searches in
NR algorithm}

\item{gamMixPor}{Proportion of mixing parameters in the penalty. The
value must be in the interval [0,1]. If \code{gamMixPor = 0}, the
penalty structure is no longer mixture.}

\item{activeset}{A matrix of zero-one that shows which intercepts and
covariates are active in the fitted fmrs model}

\item{lambMCP}{A positive numbers for \code{mcp}'s extra tuning parameter}

\item{lambSICA}{A positive numbers for \code{sica}'s extra tuning parameter}

\item{cutpoint}{A positive value for shrinking small values of parameter
estimations in the EM algorithm tward zero}
}
\value{
\code{\link{fmrsfit-class}}
}
\description{
Provides variable selection and penalized MLE for
  Finite Mixture of Accelerated Failure Time Regression (FMAFTR) Models
  and Finite Mixture of Regression (\code{FMR}) Models.
  It also provide Ridge Regression and Elastic Net.
}
\details{
The penalized likelihood of a finite mixture of AFT regression
  models is written as \deqn{\tilde\ell_{n}(\boldsymbol\Psi)
  =\ell_{n}(\boldsymbol\Psi) -
  \mathbf{p}_{\boldsymbol\lambda_{n}}(\boldsymbol\Psi)}
  where \deqn{\mathbf{p}_{\boldsymbol\lambda_{n}}(\boldsymbol\Psi) =
  \sum\limits_{k=1}^{K}\pi_{k}^\alpha\left\{
  \sum\limits_{j=1}^{d}p_{\lambda_{n,k}}(\beta_{kj}) \right\}.}
  In the M step of EM algorithm the
  function \deqn{\tilde{Q}(\boldsymbol\Psi,\boldsymbol\Psi^{(m)})
  =\sum\limits_{k=1}^{K} \tilde{Q}_{k}(\boldsymbol\Psi_k,
  \boldsymbol\Psi^{(m)}_k) =
  \sum\limits_{k=1}^{K} \left[{Q}_{k}(\boldsymbol\Psi_k,
  \boldsymbol\Psi^{(m)}_k) - \pi_{k}^\alpha\left\{
  \sum\limits_{j=1}^{d}p_{\lambda_{n,k}}(\beta_{kj}) \right\}\right]}
  is maximized. Since the penalty function is singular at origin, we
  use a local quadratic approximation (LQA) for the penalty as
  follows, \deqn{\mathbf{p}^\ast_{k,\boldsymbol\lambda_{n}}
  (\boldsymbol\beta,\boldsymbol\beta^{(m)})
  =(\pi_{k}^{(m)})^{\alpha}\sum\limits_{j=1}^{d}\left\{
  p_{\lambda_{n,k}}(\beta_{kj}^{(m)}) + { p^{\prime}_{\lambda_{n,k}}
  (\beta_{kj}^{(m)})  \over 2\beta_{kj}^{(m)}}(\beta_{kj}^{2} -
  {\beta_{kj}^{(m)}}^{2}) \right\}.} Therefore maximizing \eqn{Q} is
  equivalent to maximizing the
  function \deqn{ {Q}^\ast(\boldsymbol\Psi,\boldsymbol\Psi^{(m)})
  =\sum\limits_{k=1}^{K} {Q}^\ast_{k}(\boldsymbol\Psi_k,
  \boldsymbol\Psi^{(m)}_k) = \sum\limits_{k=1}^{K}
  \left[{Q}_{k}(\boldsymbol\Psi_k,\boldsymbol\Psi^{(m)}_k)-
  \mathbf{p}^\ast_{k,\boldsymbol\lambda_{n}}(\boldsymbol\beta,
  \boldsymbol\beta^{(m)})\right].}
  In case of Log-Normal sub-distributions, the maximizers of \eqn{Q_k}
  functions are as follows. Given the data and current estimates of
  parameters, the maximizers are \deqn{{\boldsymbol\beta}^{(m+1)}_{k}
  =({\boldsymbol z}^{\prime}\boldsymbol\tau^{(m)}_{k}{\boldsymbol z}+
  \varpi_{k}(\boldsymbol\beta_{kj}^{(m)}))^{-1}{\boldsymbol z}^{\prime}
  \boldsymbol\tau^{(m)}_{k}T^{(m)}_{k},}
  where \eqn{\varpi_{k}(\boldsymbol\beta_{kj}^{(m)})={diag}
  \left(\left(\pi_{k}^{(m+1)}\right)^\alpha
  \frac{{p}^{\prime}_{\lambda_{n},k}(\boldsymbol\beta_{kj}^{(m)})}
  {\boldsymbol\beta_{kj}^{(m)}}\right)}
  and \eqn{\sigma_{k}^{(m+1)}} is equal to \deqn{\sigma_{k}^{(m+1)}
  =\sqrt{\frac{\sum\limits_{i=1}^{n}\tau^{(m)}_{ik} (t^{(m)}_{ik}
  -{\boldsymbol z}_{i}\boldsymbol\beta^{(m)}_{k})^{2}}
  {\sum\limits_{i=1}^{n}\tau^{(m)}_{ik} {\left[\delta_{i}
  +(1-\delta_{i})\{A(w^{(m)}_{ik})[A(w^{(m)}_{ik})-
  w^{(m)}_{ik}]\}\right]}}}.}
  For the Weibull distribution, on the other hand,  we have
  \eqn{\tilde{\boldsymbol\Psi}^{(m+1)}_k
  =\tilde{\boldsymbol\Psi}^{(m)}_k
  - 0.5^{\kappa}\left[{H_{k}^{p,(m)}}\right]^{-1}I_{k}^{p,(m)}},
  where \eqn{H^p_{k}=H_k+h(\boldsymbol\Psi_k)}
  is the penalized version of hessian matrix
  and \eqn{I^p_{k}=I_k+h(\boldsymbol\Psi_k)\boldsymbol\Psi_k}
  is the penalized version of vector of first derivatives evaluated
  at \eqn{\tilde{\boldsymbol\Psi}_k^{(m)}}.
}
\examples{
set.seed(1980)
K = 2
D = 10
n = 500
sig = c(1, 1)
piM = c(0.4, 0.6)
r1 = 0.5
coeff1 = c( 2,  2, -1, -2, 1, 2, 0, 0,  0, 0,  0)
coeff2 = c(-1, -1,  1,  2, 0, 0, 0, 0, -1, 2, -2)
Um = 40

dat <- fmrs.gendata(nObs = n, nComp = K, nCov = D, coeff = c(coeff1, coeff2),
dispersion = sig, mixProp = piM, rho = r1, umax = Um, disFamily = 'lnorm')

res.mle <- fmrs.mle(y = dat$y, x = dat$x, delta = dat$delta, nComp = K,
disFamily = 'lnorm', initCoeff = rnorm(K*D+K), initDispersion = rep(1, K),
initmixProp = rep(1/K, K))

res.lam <- fmrs.tunsel(y = dat$y, x = dat$x, delta = dat$delta,
nComp = ncomp(res.mle), disFamily = 'lnorm',
initCoeff = c(coefficients(res.mle)), initDispersion = dispersion(res.mle),
initmixProp = mixProp(res.mle), penFamily = 'adplasso')

res.var <- fmrs.varsel(y = dat$y, x = dat$x, delta = dat$delta,
nComp = ncomp(res.mle), disFamily = 'lnorm',
initCoeff = c(coefficients(res.mle)), initDispersion = dispersion(res.mle),
initmixProp = mixProp(res.mle), penFamily = 'adplasso',
lambPen = slot(res.lam, 'lambPen'))

summary(res.var)
}
\references{
Shokoohi, F., Khalili, A., Asgharian, M. and Lin, S.
(2016 submitted) Variable Selection in Mixture of Survival Models for
Biomedical Genomic Studies
}
\seealso{
Other lnorm, norm, weibull: 
\code{\link{fmrs.gendata}()},
\code{\link{fmrs.mle}()},
\code{\link{fmrs.tunsel}()}
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
\concept{fmr, aft, lasso, adplasso, mcp, scad, sica, ridge, elastic net}
\concept{lnorm, norm, weibull}
\keyword{AFT}
\keyword{Adaptive}
\keyword{Algorithm}
\keyword{Censored}
\keyword{EM}
\keyword{ElasticNet}
\keyword{FMR}
\keyword{LASSO}
\keyword{MCP}
\keyword{Regression}
\keyword{Ridge}
\keyword{SCAD}
\keyword{SICA}
\keyword{Selection}
