% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSet.R
\docType{methods}
\name{plotValidationGraph}
\alias{plotValidationGraph}
\alias{plotValidationGraph,SampleSet-method}
\title{plot of Validation Graph for determing number of components}
\usage{
plotValidationGraph(object, type.fits = "PCR", pdf.file = NULL)

\S4method{plotValidationGraph}{SampleSet}(object, type.fits = "PCR",
  pdf.file = NULL)
}
\arguments{
\item{object}{of class SampleSet}

\item{type.fits}{can be "PCR" or "PLS" (default "PCR")}

\item{pdf.file}{if no file name is provided print pdf file 
plotValidationGraph.pdf in working directory.}
}
\value{
No value is returned.  The function prints the plots to a pdf file.
}
\description{
Plots a series of graphs for each signal type, to determine 
the number of components to include in the normalization procedure.
}
\section{Methods (by class)}{
\itemize{
\item \code{SampleSet}: Plots a series of graphs for each 
signal type, to determine the number of components to include 
in the normalization procedure.
}}

\examples{
require(minfiData)
pData(RGsetEx)$cell_type <- rep(c("type1","type2"),3)
mySampleSet=fromRGChannelSet(RGsetEx)
plotValidationGraph(mySampleSet)

}
