% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateSignalSummary.R
\name{ct.contrastBarchart}
\alias{ct.contrastBarchart}
\title{Visualize Signal Across A List of Contrasts}
\usage{
ct.contrastBarchart(
  dflist,
  background = TRUE,
  statistic = c("best.q", "best.p"),
  ...
)
}
\arguments{
\item{dflist}{A named list of `data.frame`s summarizing the results of one or more screen contrasts, returned by the function 
\code{\link{ct.generateResults}}.}

\item{background}{Logical indicating whether to represent the nonsignificant hits in the barchart.}

\item{statistic}{Should cutoffs be calculated based on FDR (`best.q`) or P-value (`best.p`)?}

\item{...}{Other parameters to lower functions, especially `ct.simpleResult()`}
}
\value{
A summary plot on the current device. Invisibly, the data.frame tallying signals at various thresholds.
}
\description{
Given a list of provided results `data.frame`s summarizing a series of contrasts from one or more pooled screens, 
this function visualizes their respective signals as a series of stacked barcharts. Enriched signals 
are represented in the positive direction, and depleted signals are represented in the negative direction.  Note that the 
provided contrast results are not regularized by this function.

This function may be used to compare signals across different screen contrasts, or to compare signals within interesting 
subsets of targets ascertained within a single experiment.
}
\examples{
data('resultsDF')
ct.contrastBarchart(list('FirstResult' = resultsDF, 'SecondResult' = resultsDF))
ct.contrastBarchart(list('FirstResult' = resultsDF, 'SecondResult' = resultsDF), background = FALSE)
ct.contrastBarchart(list('FirstResult' = resultsDF[1:1000,], 'SecondResult' = resultsDF))
}
\author{
Russell Bainer
}
