% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GuideCDF.R
\name{ct.guideCDF}
\alias{ct.guideCDF}
\title{View CDFs of the ranked gRNAs or Targets present in a crispr screen}
\usage{
ct.guideCDF(eset, sampleKey = NULL, plotType = "gRNA", annotation = NULL)
}
\arguments{
\item{eset}{An ExpressionSet  object containing, at minimum, a matrix of gRNA abundances extractable with the exprs() function.}

\item{sampleKey}{An optional sample key, supplied as an ordered factor linking the samples to experimental 
variables. The \code{names} attribute should exactly match those present in \code{eset}, and the control set is assumed to be 
the first \code{level}.}

\item{plotType}{A string indicating whether the individual guides should be displayed ('\code{gRNA}'), or if they should be aggregated into target-level
estimates ('\code{Target}') according to the \code{geneSymbol} column in the \code{annotation} object.}

\item{annotation}{An optional data.frame containing an annotation object to be used to aggregate the guides into targets. gRNAs are annotated by row, 
and must minimally contain a column \code{geneSymbol} indicating the target elements.}
}
\value{
A CDF plot displaying the appropriate CDF curves on the default device.
}
\description{
This function generates a plot relating the cumulative proportion of reads in each sample of a crispr screen to the abundance rank of the 
underlying guides (or Targets). The purpose of this algorithm is to detect potential distortions in the library composition 
that might not be properly controlled by sample normalization (see also: \code{ct.stackedGuides()}).
}
\examples{
data('es')
ct.guideCDF(es)
}
\author{
Russell Bainer
}
