% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateReports.R
\name{ct.makeReport}
\alias{ct.makeReport}
\title{Generate a full experimental report from a pooled CRISPR screen}
\usage{
ct.makeReport(
  fit,
  eset,
  sampleKey,
  annotation,
  results,
  aln,
  outdir = NULL,
  contrast.term = NULL,
  identifier = NULL
)
}
\arguments{
\item{fit}{An object of class \code{MArrayLM} containing, at minimum, a \code{coefficents} slot with coefficients from the comparison,
and a \code{stdev.unscaled} slot with the corresponding standard deviation of the coefficent estimates. The \code{row.names} attribute
should ideally match that which is found in \code{annotation}, but this will be checked internally.}

\item{eset}{An ExpressionSet object containing, at minimum, a matrix of gRNA abundances extractable with the \code{exprs()} function and some named
phenodata extractable with \code{pData()}.}

\item{sampleKey}{A sample key, supplied as an ordered factor linking the samples to experimental
variables. The \code{names} attribute should exactly match those present in \code{eset}, and the control set is assumed to be
the first \code{level}.}

\item{annotation}{An annotation object for the experiment. See the man page for \code{ct.prepareAnnotation()} for details and example format.}

\item{results}{A data.frame summarizing the results of the screen, returned by the function \code{\link{ct.generateResults}}.}

\item{aln}{A numeric alignment matrix, where rows correspond to 'targets', 'nomatch', 'rejections', and 'double_match', and where columns 
correspond to experimentasl samples. Users may also pass `NULL` to suppress evaluation of alignment.}

\item{outdir}{A directory in which to generate the report; if \code{NULL}, a temporary directory will be automatically generated. 
The report will be located in a subdirectory whose name is internally generated (see below). The path to the report itself is returned by the function.}

\item{contrast.term}{A parameter passed to \code{ct.preprocessFit} in the event that the fit object contains data from multiple contrasts. See
that man page for further details.}

\item{identifier}{A character string to name the report and corresponding subdirectories. If provided, the final report will be called
'\code{identifier}.html' and will be located in a directory called \code{identifier} in the \code{outdir}. If \code{NULL}, a generic name 
including the timestamp will be generated.}
}
\value{
The path to the generated html report.
}
\description{
This is a function to generate an html report for a CRISPR screen, incorporating information about a specified contrast. 
The report contains a combination of experiment-level and contrast-specific analyses, largely collected from other functions in 
\code{gCrisprTools}. It is designed to be used 'as-is', and analysts interested in using different functionalities of the various 
functions should do that outside of this wrapper script.
}
\examples{
data('fit')
data('es')

##' #Build the sample key
library(Biobase)
sk <- relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference')
names(sk) <- row.names(pData(es))

data('ann')
data('resultsDF')
data('aln')
path2report <- ct.makeReport(fit, es, sk, ann, resultsDF, aln, outdir = '.') 
}
\author{
Russell Bainer
}
