% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Raw_read_densities.R
\name{ct.rawCountDensities}
\alias{ct.rawCountDensities}
\title{Visualization of Raw gRNA Count Densities}
\usage{
ct.rawCountDensities(eset, sampleKey = NULL, lib.size = NULL)
}
\arguments{
\item{eset}{An ExpressionSet object containing, at minimum, count data accessible by exprs() and some phenoData.}

\item{sampleKey}{A sample key, supplied as a (possibly ordered) factor linking the samples to experimental 
variables. The \code{names} attribute should exactly match those present in \code{eset}, and the control set 
is assumed to be the first \code{level}.}

\item{lib.size}{Optional named vector of library sizes (total reads within the library) to enable normalization}
}
\value{
A density plot as specified on the default device.
}
\description{
This function plots the per-sample densities of raw gRNA read counts on the log10 scale. The curve colors are assigned based on a user-
specified sampleKey. This function is primarily useful to determine whether libraries are undersequenced (low mean raw gRNA counts), 
contaminated (many low-abundance gRNAs present), or if PCR artifacts may be present (subset of extremely abundant guides, multiple gRNA distribution modes). In most 
well-executed experiments the majority of gRNAs will form a tight distribution around some reasonably high average read count (hundreds of reads), 
at least among the control samples. Excessively low raw count values can compromise normalization steps and subsequent estimation of gRNA levels, especially 
in screens in which most gRNAs have minimal effects on cell viability.
}
\examples{
data('es')

#Build the sample key
library(Biobase)
sk <- relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference')
names(sk) <- row.names(pData(es))

ct.rawCountDensities(es, sk)
}
\author{
Russell Bainer
}
