% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{gDNAx-class}
\alias{gDNAx-class}
\alias{getDx}
\alias{getDx,gDNAx-method}
\alias{show,gDNAx-method}
\alias{show}
\alias{getIgc}
\alias{getIgc,gDNAx-method}
\alias{getInt}
\alias{getInt,gDNAx-method}
\alias{singleEnd,gDNAx-method}
\alias{singleEnd}
\alias{strandMode,gDNAx-method}
\alias{strandMode}
\alias{strandMode<-,gDNAx-method}
\alias{strandMode<-}
\alias{allStrandModes,gDNAx-method}
\alias{allStrandModes}
\alias{strandedness,gDNAx-method}
\alias{strandedness}
\title{gDNAx class}
\usage{
\S4method{getDx}{gDNAx}(x)

\S4method{show}{gDNAx}(object)

\S4method{getIgc}{gDNAx}(x)

\S4method{getInt}{gDNAx}(x)

\S4method{singleEnd}{gDNAx}(x)

\S4method{strandMode}{gDNAx}(x)

\S4method{strandMode}{gDNAx}(x) <- value

\S4method{allStrandModes}{gDNAx}(x)

\S4method{strandedness}{gDNAx}(x, ...)
}
\arguments{
\item{x}{A \linkS4class{gDNAx} object.}

\item{object}{A \linkS4class{gDNAx} object.}

\item{value}{Integer value either 0, 1, 2 or \code{NA}, indicating how
the strand of a pair of read alignments should be inferred from the strand
of the first and last alignments in the pair. See the
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail.}

\item{...}{Further arguments when \code{x} is not a \linkS4class{gDNAx}
object; see the help page of \code{\link{gDNAdx}()}.}
}
\value{
\code{getDx()}: A \code{data.frame} object with the following
columns:
\itemize{
\item \code{IGC}: percentage of read alignments fully contained in
intergenic regions.
\item \code{INT}: percentage of read alignments fully contained in
intronic regions.
\item \code{SCJ}: percentage of splice-compatible junction read
alignments. These are alignments compatible with a transcript
in the given annotation, for which the aligned read, or at
least one of the two aligned reads in the case of a paired-end
layout, spans one or more exon-exon junctions over two or more
exons of that transcript.
\item \code{SCE}: percentage of splice compatible exonic alignments.
These are alignments compatible with a transcript in the given
annotation, but which differently to SCJ alignments, do not
include an exon-exon junction in the alignment.
\item \code{JNC}: percentage of alignments that include one or more
junctions, irrespective of whether those alignments are compatible
with an spliced transcript in the given annotation.
\item \code{*FLM}: estimation of the fragment length mean in the
alignments of the corresponding type (\code{IGC}, \code{SCJ}, or
\code{SCE}).
\item \code{STRAND}: strandedness values, with \code{NA} in the case
that the data is unstranded.
}

\code{getIgc()}: A \code{GRanges} object with intergenic ranges.

\code{getInt()}: A \code{GRanges} object with intron ranges.

\code{singleEnd()}: Logical value indicating whether the
\code{\linkS4class{gDNAx}} object contains data from a single-end
(\code{TRUE}) or a paired-end (\code{FALSE}) RNA-seq experiment.

\code{strandMode()}: Integer value indicating whether the
\code{\linkS4class{gDNAx}} object contains data from an unstranded
(\code{NA}), stranded with the first mate read indicating the real
strand (\code{1}), or stranded with the last mate read indicating
the real strand (\code{2}) from an RNA-seq experiment.

Vector of strand modes for each BAM file in the
\linkS4class{gDNAx} object.

A \code{data.frame} object with strandedness values for each
BAM file in the \linkS4class{gDNAx} object.
}
\description{
This is a class for storing the results of a call to the 'gDNAdx()' function.
}
\section{Slots}{

\describe{
\item{\code{bfl}}{A \code{\link[Rsamtools:BamFile-class]{BamFileList}} object.}

\item{\code{txdbpkg}}{A \code{\link[GenomicFeatures:TxDb-class]{TxDb}} object.}

\item{\code{singleEnd}}{Logical value indicating if reads are single (\code{TRUE})
or paired-end (\code{FALSE}).}

\item{\code{strandMode}}{Integer value either 0, 1, 2 or \code{NA}, indicating how
the strand of a pair of read alignments should be inferred from the strand
of the first and last alignments in the pair. See the
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail.}

\item{\code{allStrandModes}}{Vector of integer values each of them corresponding to
a \code{strandMode} value estimated from a BAM file.}

\item{\code{suppSpeciesInAnnot}}{Logical value indicating whether the species metdata
in the input annotations is supported by the information available at the
Bioconductor GenomeInfoDb package.}

\item{\code{stdChrom}}{Logical value indicating whether only alignments in the
'standard chromosomes' should be used. Consult the help page of the function
\code{\link[GenomeInfoDb]{keepStandardChromosomes}} from the package
\code{GenomeInfoDb} for further information.}

\item{\code{readLength}}{Integer value storing the read length.}

\item{\code{yieldSize}}{Integer value storing the number of alignments employed by
the function \code{\link{gDNAdx}()}.}

\item{\code{diagnostics}}{A 'data.frame' object storing the diagnostics calculated
by the function 'gDNAdx()'.}

\item{\code{strandedness}}{A 'data.frame' object storing the estimated values of
strandedness, calculated when the argument \code{strandMode} is missing in
the call to the function 'gDNAdx()'.}

\item{\code{igcfrglen}}{A 'list' object storing the fragment lengths derived from
alignments in intergenic regions.}

\item{\code{intfrglen}}{A 'list' object storing the fragment lengths derived from
alignments in intronic regions.}

\item{\code{scjfrglen}}{A 'list' object storing the fragment lengths derived from
spliced-compatible junction alignments in transcripts.}

\item{\code{scefrglen}}{A 'list' object storing the fragment lengths derived
from spliced-compatible exonic alignments in transcripts.}

\item{\code{sicfrglen}}{A 'list' object storing the fragment lengths derived
from splice-incompatible alignments in transcripts.}

\item{\code{intergenic}}{A 'GRanges' object storing the intergenic feature
annotations.}

\item{\code{intronic}}{A 'GRanges' object storing the intronic feature
annotations.}

\item{\code{transcripts}}{A 'GRangesList' object storing the transcript annotations.}

\item{\code{tx2gene}}{A string character vector storing the correspondence between
transcripts and genes according to an 'TxDb' object.}
}}

\examples{
library(gDNAinRNAseqData)
library(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
bamfiles <- LiYu22subsetBAMfiles() # Retrieving BAM files
## one could simply call 'gDNAx(bamfiles, txdb)' but we give the arguments
## below to reduce time and verbosity when running this example
gdnax <- gDNAdx(bamfiles, txdb, singleEnd=FALSE, strandMode=NA,
                useRMSK=FALSE, verbose=FALSE)
gdnax


# Getting statistics
dx <- getDx(gdnax)
head(dx)

gdnax

igc <- getIgc(gdnax)
head(igc, n=3)

int <- getInt(gdnax)
head(int, n=3)

singleEnd(gdnax)

strandMode(gdnax)

strandMode(gdnax) <- NA

allStrandModes(gdnax)

strandedness(gdnax)

}
