% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{average_biological_replicates_dt}
\alias{average_biological_replicates_dt}
\title{Average biological replicates on the data table side.}
\usage{
average_biological_replicates_dt(
  dt,
  var,
  prettified = FALSE,
  fixed = TRUE,
  geometric_average_fields = get_header("metric_average_fields")$geometric_mean,
  fit_type_average_fields = get_header("metric_average_fields")$fit_type,
  blacklisted_fields = get_header("metric_average_fields")$blacklisted,
  add_sd = FALSE
)
}
\arguments{
\item{dt}{data.table with Metric data}

\item{var}{String representing additional metadata of replicates}

\item{prettified}{Flag indicating if the provided identifiers in the dt are prettified}

\item{fixed}{Flag indicating whether to add a fix for -Inf in the geometric mean.}

\item{geometric_average_fields}{Character vector of column names in \code{dt}
to take the geometric average of.}

\item{fit_type_average_fields}{Character vector of column names in \code{dt}
that should be treated as a column with fit type data}

\item{blacklisted_fields}{Character vector of column names in \code{dt}
that should be skipped in averaging}

\item{add_sd}{Flag indicating whether to add standard deviation and count columns.}
}
\value{
data.table without replicates
}
\description{
Average biological replicates on the data table side.
}
\examples{
dt <- data.table::data.table(a = c(seq_len(10), 1),
b = c(rep("drugA", 10), rep("drugB", 1)))
average_biological_replicates_dt(dt, var = "a")

}
\keyword{package_utils}
