% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{has_assay_dt_duplicated_rows}
\alias{has_assay_dt_duplicated_rows}
\title{check if assay data contains duplicated data}
\usage{
has_assay_dt_duplicated_rows(dt)
}
\arguments{
\item{dt}{data.table with assay data}
}
\value{
logical flag indicating if a dt contains duplicated rows or not
}
\description{
An auxiliary function that checks for duplicates in the assay data
}
\examples{
sdata <- get_synthetic_data("finalMAE_small")
smetrics_data <- convert_se_assay_to_dt(sdata[[1]], "Metrics")
has_assay_dt_duplicated_rows(smetrics_data)
}
\keyword{duplicates}
