% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettify.R
\name{prettify_flat_metrics}
\alias{prettify_flat_metrics}
\title{Prettify metric names in flat 'Metrics' assay}
\usage{
prettify_flat_metrics(
  x,
  human_readable = FALSE,
  normalization_type = c("GR", "RV")
)
}
\arguments{
\item{x}{character vector of names to prettify.}

\item{human_readable}{boolean indicating whether or not to return column names in human readable format.
Defaults to \code{FALSE}.}

\item{normalization_type}{character vector with a specified normalization type.
Defaults to \code{c("GR", "RV")}.}
}
\value{
character vector of prettified names.
}
\description{
Map existing column names of a flattened 'Metrics' assay to prettified names.
}
\details{
A common use case for this function is to prettify column names from a flattened version of
the \code{"Metrics"} assay.
Mode \code{"human_readable" = TRUE} is often used for prettification in the context
of front-end applications, whereas \code{"human_readable" = FALSE} is often used for
prettification in the context of the command line.
}
\examples{
x <- c("CellLineName", "Tissue", "Primary Tissue", "GR_gDR_x_mean", "GR_gDR_xc50", "RV_GDS_x_mean")
prettify_flat_metrics(x, human_readable = FALSE)

}
\keyword{identifiers}
