% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combo.R
\name{convert_combo_data_to_dt}
\alias{convert_combo_data_to_dt}
\title{convert combo assays from SummarizedExperiments to the list of data.tables}
\usage{
convert_combo_data_to_dt(
  se,
  c_assays = get_combo_assay_names(),
  normalization_type = c("RV", "GR"),
  prettify = TRUE
)
}
\arguments{
\item{se}{\code{SummarizedExperiment} object with dose-response data}

\item{c_assays}{charvec of combo assays to be used}

\item{normalization_type}{charvec of normalization_types expected in the data}

\item{prettify}{boolean flag indicating whether or not to prettify the colnames of the returned data}
}
\value{
list of data.table(s) with combo data
}
\description{
convert combo assays from SummarizedExperiments to the list of data.tables
}
\examples{
mae <- get_synthetic_data("finalMAE_combo_matrix_small.qs")
convert_combo_data_to_dt(mae[[1]])

}
\author{
Arkadiusz Gładki \email{arkadiusz.gladki@contractors.roche.com}
}
\keyword{combination_data}
