% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curves.R
\name{fit_curves}
\alias{fit_curves}
\title{Fit curves}
\usage{
fit_curves(
  df_,
  series_identifiers,
  e_0 = 1,
  GR_0 = 1,
  n_point_cutoff = 4,
  range_conc = c(0.005, 5),
  force_fit = FALSE,
  pcutoff = 0.05,
  cap = 0.1,
  normalization_type = c("GR", "RV")
)
}
\arguments{
\item{df_}{data.table containing data to fit. See details.}

\item{series_identifiers}{character vector of the column names in \code{data.table}
whose combination represents a unique series for which to fit curves.}

\item{e_0}{numeric value representing the \code{x_0} value for the RV curve.
Defaults to \code{1}.}

\item{GR_0}{numeric value representing the \code{x_0} value for the GR curve.
Defaults to \code{1}.}

\item{n_point_cutoff}{integer of how many points should be considered the minimum required to try to fit a curve.
Defaults to \code{4}.}

\item{range_conc}{numeric vector of length 2 indicating the lower and upper concentration ranges.
Defaults to \code{c(5e-3, 5)}. See details.}

\item{force_fit}{boolean indicating whether or not to force a constant fit.
Defaults to \code{FALSE}.}

\item{pcutoff}{numeric of pvalue significance threshold above or equal to which to use a constant fit.
Defaults to \code{0.05}.}

\item{cap}{numeric value capping \code{norm_values} to stay below (\code{x_0} + cap).
Defaults to \code{0.1}.}

\item{normalization_type}{character vector of types of curves to fit.
Defaults to \code{c("GR", "RV")}.}
}
\value{
data.table of fit parameters as specified by the \code{normalization_type}.
}
\description{
Fit GR and RV curves from a data.table.
}
\details{
The \code{df_} expects the following columns:
\itemize{
\item{RelativeViability} normalized relative viability values (if \code{normalization_type} includes \code{"RV"})
\item{GRvalue} normalized GR values (if \code{normalization_type} includes \code{"GR"})
}

The \code{range_conc} is used to calculate the \code{x_AOC_range} statistic.
The purpose of this statistic is to enable comparison across different experiments with slightly
different concentration ranges.
}
\examples{
df_ <- data.table::data.table(Concentration = c(0.001, 0.00316227766016838, 
0.01, 0.0316227766016838),
x_std = c(0.1, 0.1, 0.1, 0.1), normalization_types = c("RV", "RV", "RV", "RV"),
x = c(0.9999964000144, 0.999964001439942, 0.999640143942423, 0.996414342629482))

fit_curves(df_, "Concentration", normalization_type = "RV")

}
\keyword{fit_curves}
