% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{get_duplicated_rows}
\alias{get_duplicated_rows}
\title{Helper function to find duplicated rows}
\usage{
get_duplicated_rows(x, col_names = NULL, output = "index")
}
\arguments{
\item{x}{DataFrame or data.table}

\item{col_names}{character vector, columns in which duplication are searched for}

\item{output}{string with the output format to be returned -
one of "index" (index of duplicates) or "data" (subset of input data with duplicates)}
}
\value{
integer vector or data.table with duplicated rows
}
\description{
Helper function to find duplicated rows
}
\examples{
dt <- data.table::data.table(a = c(1, 2, 3), b = c(3, 2, 2))
get_duplicated_rows(dt, "b")
get_duplicated_rows(dt, "b", output = "data")
}
\keyword{duplicates}
