% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_additional_metadata.R
\name{modifyData}
\alias{modifyData}
\alias{modifyData.drug_name2}
\alias{modifyData.data_source}
\alias{modifyData.default}
\title{modify assay with additional data}
\usage{
modifyData(x, ...)

\method{modifyData}{drug_name2}(x, option, keep, ...)

\method{modifyData}{data_source}(x, option, keep, ...)

\method{modifyData}{default}(x, option, keep, ...)
}
\arguments{
\item{x}{a \code{data.table} containing an assay}

\item{...}{additional arguments passed to methods}

\item{option}{character string specifying the action to be taken, see \code{Details}}

\item{keep}{character string specifying the value of the active variable that will be kept}
}
\value{
modified object
}
\description{
Reduce dimensionality of an assay by dropping extra data or combining variables.
}
\details{
If an essay extracted from a \code{SummarizedExperiment} contains additional information,
i.e. factors beyond \code{DrugName} and \code{CellLineName}, that information will be treated
in one of three ways, depending on the value of \code{option}:

\itemize{
\item{\code{drop}: Some information will be discarded and only one value
of the additional variable (chosen by the user) will be kept.
}
\item{\code{toDrug}: The information is pasted together with the primary drug name.
All observations are kept.
}
\item{\code{toCellLine}: As above, but pasting is done with cell line name.
}
}

Depending on the type of additional information, the exact details will differ.
This is handled in the app by adding special classes to the data tables and dispatching to S3 methods.

Following modification, the additional columns are discarded.
}
\section{Methods (by class)}{
\itemize{
\item \code{modifyData(drug_name2)}: includes the name and concentration of the second drug

\item \code{modifyData(data_source)}: includes the data source

\item \code{modifyData(default)}: includes the name of other additional variables

}}
\examples{
dt <- data.table::data.table(a = as.character(1:10), b = "data")
dt <- addClass(dt, "a")
modifyData(dt, "average", keep = "b")

}
\keyword{metadata_management}
