% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractOverlaps.R
\name{extractOverlaps}
\alias{extractOverlaps}
\title{Extract Overlap Groups from Genomic or Set Overlap Results}
\usage{
extractOverlaps(overlap_object)
}
\arguments{
\item{overlap_object}{A \code{GenomicOverlapsResult} or \code{SetOverlapsResult}
object.}
}
\value{
A named list of grouped intersecting elements:
\itemize{
\item If input is a \code{GenomicOverlapsResult}, a \code{GRangesList} split
by \code{intersect_category}.
\item If input is a \code{SetOverlapsResult}, a named \code{list} of character vectors
grouped by \code{intersect_category}.
}
}
\description{
This function extracts subsets of intersecting elements grouped by their
overlap category (e.g., "110").
For genomic overlaps, it returns a \code{GRangesList}; for set overlaps, it
returns a named list of character vectors.
}
\examples{
# Example with gene sets (built-in dataset)
data(gene_list)
res_sets <- computeOverlaps(gene_list)
group_gene <- extractOverlaps(res_sets)
group_gene

# Example with genomic regions (built-in dataset)
data(a549_chipseq_peaks)
res_genomic <- computeOverlaps(a549_chipseq_peaks)
group_genomic <- extractOverlaps(res_genomic)
group_genomic
}
