% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_dataset_platforms}
\alias{get_dataset_platforms}
\title{Retrieve the platforms of a dataset}
\usage{
get_dataset_platforms(
  dataset,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{dataset}{A numerical dataset identifier or a dataset short name}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the platform(s). A list if \code{raw = TRUE}. A \code{404 error} if the given identifier
does not map to any object

The fields of the output data.table are:
\itemize{
\item \code{platform.ID}: Internal identifier of the platform
\item \code{platform.shortName}: Shortname of the platform.
\item \code{platform.name}: Full name of the platform.
\item \code{platform.description}: Free text description of the platform
\item \code{platform.troubled}: Whether or not the platform was marked "troubled" by a Gemma process or a curator
\item \code{platform.experimentCount}: Number of experiments using the platform within Gemma
\item \code{platform.type}: Technology type for the platform.
\item \code{taxon.name}: Name of the species platform was made for
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underyling database used in Gemma for the taxon
}
}
\description{
Retrieve the platforms of a dataset
}
\examples{
get_dataset_platforms("GSE2018")
}
\keyword{dataset}
