% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processors.R
\name{processSamples}
\alias{processSamples}
\title{Processes JSON as a vector of samples}
\usage{
processSamples(d)
}
\arguments{
\item{d}{The JSON to process}
}
\value{
A data table with information about the samples of the queried dataset. A list if
\code{raw = TRUE}. A \code{404 error} if the given identifier does not map to any object.

The fields of the output data.table are:
\itemize{
\item \code{sample.name}: Internal name given to the sample.
\item \code{sample.ID}: Internal ID of the sample
\item \code{sample.description}: Free text description of the sample
\item \code{sample.outlier}: Whether or not the sample is marked as an outlier
\item \code{sample.accession}: Accession ID of the sample in it's original database
\item \code{sample.database}: Database of origin for the sample
\item \code{sample.characteristics}: Characteristics of the sample. This field is a data table
\item \code{sample.factorValues}: Experimental factor values of the sample. This field is a data table
}
}
\description{
Processes JSON as a vector of samples
}
\keyword{internal}
