% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaksMerge.r
\name{peaksMerge}
\alias{peaksMerge}
\title{Transform peaks into merged peaks.}
\usage{
peaksMerge(filename, mergeby)
}
\arguments{
\item{filename}{Name of file containing peaks that have been generated from a peak caller (e.g., MACS2, SICER).  See ?samplepeaksinput for an example of such an input file.}

\item{mergeby}{Integer indicating how close two adjacent sorted peaks need to be in order to be merged into one peak.}
}
\value{
Returns a formatted file (called "peaks.txt"), deposited in the user's working directory, which has been preprocessed to transform individual peaks into merged peaks in preparation for usage with barChart(), linePlot(), distinct(), and other downstream commands.
}
\description{
Takes your tab-delimited 3-column (chromosome number, peak start, and peak end) input file (see ?samplepeaksinput) consisting of peaks called from a peak caller (e.g., MACS2 or SICER) and transforms this file into a file of merged peaks.  This file (called "peaks.txt") is a preprocessed file of the original input transformed into merged peaks, and it is deposited in the user's working directory and used for the remainder of the analysis.  In this "peaks.txt" file, peaks are sorted by chromosome number and start position, where the X chromosome is designated by the integer 100, the Y chromosome by the integer 200, and the mitochondrial chromosome by the integer 300.
}
\examples{
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksMerge(fpath, 500)

}
