% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene76.R
\name{gene76}
\alias{gene76}
\title{Function to compute the Relapse Score as published by Wang et al. 2005}
\usage{
gene76(data, er)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in columns,
dimnames being properly defined.}

\item{er}{Vector containing the estrogen receptor (ER) status of breast cancer patients in
the dataset.}
}
\value{
A list with items:
\itemize{
\item score Continuous signature scores
\item risk Binary risk classification, 1 being high risk and 0 being low risk.
}
}
\description{
This function computes signature scores and risk classifications from gene
expression values following the algorithm used for the Relapse Score (GENE76) as
published by Wang et al. 2005.
}
\examples{
# load GENE76 signature
data(sig.gene76)
# load VDX dataset
data(vdxs)
# compute relapse score
rs.vdxs <- gene76(data=data.vdxs, er=demo.vdxs[ ,"er"])
table(rs.vdxs$risk)

}
\references{
Y. Wang and J. G. Klijn and Y. Zhang and A. M. Sieuwerts and M. P. Look and F.
Yang and D. Talantov and M. Timmermans and M. E. Meijer-van Gelder and J. Yu and T.
Jatkoe and E. M. Berns and D. Atkins and J. A. Foekens (2005) "Gene-Expression
Profiles to Predict Distant Metastasis of Lymph-Node-Negative Primary Breast Cancer",
Lancet, 365(9460):671–679.
}
\seealso{
\link{ggi}
}
