% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDEE2.R
\name{getDEE2_bundle}
\alias{getDEE2_bundle}
\title{Get a DEE2 project bundle}
\usage{
getDEE2_bundle(
  species,
  query,
  col,
  counts = "GeneCounts",
  bundles = NULL,
  legacy = FALSE,
  baseURL = "http://dee2.io/huge/",
  ...
)
}
\arguments{
\item{species}{A character string matching the species of interest.}

\item{query}{A character string, such as  the SRA project accession number
or the GEO series accession number}

\item{col}{the column name to be queried, usually "SRP_accession" for SRA
project accession or "GSE_accession" for GEO series accession.}

\item{counts}{A string, either 'GeneCounts', 'TxCounts' or 'Tx2Gene'.
When 'GeneCounts' is specified, STAR gene level counts are returned.
When 'TxCounts' is specified, kallisto transcript counts are returned.
When 'Tx2Gene' is specified, kallisto counts aggregated (by sum) on gene
are returned. If left blank, "GeneCounts" will be fetched.}

\item{bundles}{optional table of previously downloaded bundles.
providing this will speed up performance if multiple queries are made in a
session. If left blank, the bundle list will be fetched again.}

\item{legacy}{Whether data should be returned in the legacy (list) format.
Default is FALSE. Leave this FALSE if you want to receive data as
Summarized experiment.}

\item{baseURL}{The base URL of the service. Leave this as the default URL
unless you want to download from a 3rd party mirror.}

\item{...}{Additional parameters to be passed to download.file.}
}
\value{
a SummarizedExperiment object.
}
\description{
The getDEE2_bundle function fetches gene expression data from DEE2.
This function will only work if all SRA runs have been successfully 
processed for an SRA project. This function returns a 
SummarizedExperiment object.
}
\examples{
x <- getDEE2_bundle("celegans", "SRP133403",col="SRP_accession")
}
\keyword{DEE2}
\keyword{RNA-seq}
\keyword{database}
