% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDEE2.R
\name{srx_agg}
\alias{srx_agg}
\title{Summarized run data to experiments}
\usage{
srx_agg(x, counts = "GeneCounts")
}
\arguments{
\item{x}{a getDEE2 object.}

\item{counts}{select "GeneCounts" for STAR based gene counts, "TxCounts" for
kallisto transcript level counts or "Tx2Gene" for transcript counts
aggregated to gene level. Default is "GeneCounts"}
}
\value{
a dataframe with gene expression data summarised to SRA experiment
accession numbers rather than run accession numbers.
}
\description{
Sometimes, each SRA experiment data is represented in two or more runs and
they need to be aggregated.
}
\examples{
x <- getDEE2("ecoli",c("SRR1613487","SRR1613488"),legacy=TRUE)
y <- srx_agg(x)
}
